/*
 * Decompiled with CFR 0.152.
 */
package org.miniorange.saml;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.miniorange.saml.MoSAMLException;
import org.miniorange.saml.MoSAMLPluginSettings;
import org.miniorange.saml.MoSAMLResponse;
import org.miniorange.saml.MoSAMLUtils;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.validation.ValidationException;

public class MoSAMLManager {
    private String certificateexpected = "";
    private static final Logger LOGGER = Logger.getLogger(MoSAMLManager.class.getName());

    public MoSAMLResponse readSAMLResponse(HttpServletRequest request, HttpServletResponse response, MoSAMLPluginSettings settings) {
        try {
            MoSAMLUtils.doBootstrap();
            String encodedSAMLResponse = request.getParameter("SAMLResponse");
            Response samlResponse = MoSAMLUtils.decodeResponse(encodedSAMLResponse);
            if (!StringUtils.equals((CharSequence)samlResponse.getStatus().getStatusCode().getValue(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:status:Success")) {
                LOGGER.fine("Invalid SAML response. SAML Status Code received: " + samlResponse.getStatus().getStatusCode().getValue());
                String message = "";
                if (samlResponse.getStatus().getStatusMessage() != null) {
                    LOGGER.fine("Saml Status Message received: " + samlResponse.getStatus().getStatusMessage().getMessage());
                    message = samlResponse.getStatus().getStatusMessage().getMessage() + ". Status Code received in SAML response: " + samlResponse.getStatus().getStatusCode().getValue().split(":")[7];
                } else {
                    message = "Invalid status code \"" + samlResponse.getStatus().getStatusCode().getValue().split(":")[7] + "\" received in SAML response";
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)samlResponse.getStatus().getStatusCode().getValue().split(":")[7], (CharSequence)"urn:oasis:names:tc:SAML:2.0:status:Responder")) {
                    LOGGER.fine(message);
                    throw new MoSAMLException(message, MoSAMLException.SAMLErrorCode.RESPONDER);
                }
                LOGGER.fine(message);
                throw new MoSAMLException(message, MoSAMLException.SAMLErrorCode.INVALID_SAML_STATUS);
            }
            Assertion assertion = samlResponse.getAssertions() != null && samlResponse.getAssertions().size() > 0 ? (Assertion)samlResponse.getAssertions().get(0) : MoSAMLUtils.decryptAssertion((EncryptedAssertion)samlResponse.getEncryptedAssertions().get(0), settings.getPublicSPCertificate(), settings.getPrivateSPCertificate());
            String inResponseTo = null;
            List confirmations = assertion.getSubject().getSubjectConfirmations();
            if (confirmations != null && !confirmations.isEmpty()) {
                for (SubjectConfirmation confirmation : confirmations) {
                    SubjectConfirmationData data = confirmation.getSubjectConfirmationData();
                    if (data == null) continue;
                    inResponseTo = data.getInResponseTo();
                }
            }
            LOGGER.fine(String.valueOf(assertion));
            this.verifyConditions(assertion, settings.getSPAudienceURI());
            String acs = settings.getSpAcsUrl();
            this.verifyIssuer(samlResponse, assertion, settings.getIdpEntityId());
            this.verifyDestination(samlResponse, acs);
            this.verifyRecipient(assertion, acs);
            MoSAMLException t = null;
            Boolean verified = Boolean.FALSE;
            try {
                verified = this.verifyCertificate(samlResponse, assertion, settings.getPublicx509Certificate());
                LOGGER.fine("Verified Certificates:" + verified);
            }
            catch (MoSAMLException e) {
                t = e;
            }
            if (!verified.booleanValue()) {
                LOGGER.fine(t.getMessage());
                throw t;
            }
            Map<String, String[]> attributes = this.getAttributes(assertion);
            NameID nameId = assertion.getSubject().getNameID();
            String nameIdValue = "";
            String sessionIndex = ((AuthnStatement)assertion.getAuthnStatements().get(0)).getSessionIndex();
            if (nameId != null) {
                nameIdValue = nameId.getValue();
            }
            attributes.put("NameID", new String[]{nameIdValue});
            MoSAMLResponse samlResponseObj = new MoSAMLResponse(attributes, nameIdValue, sessionIndex, inResponseTo);
            return samlResponseObj;
        }
        catch (MoSAMLException e) {
            LOGGER.fine(e.getMessage());
            throw e;
        }
        catch (Throwable e) {
            LOGGER.fine("An error occurred while verifying the SAML Response.");
            throw new MoSAMLException(e, MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private void verifyIssuer(Response response, Assertion assertion, String idpEntityId) {
        LOGGER.fine("Verifying Issuer in SAML Response");
        String issuerInResponse = response.getIssuer().getValue();
        String issuerInAssertion = assertion.getIssuer().getValue();
        if (!StringUtils.equals((CharSequence)issuerInResponse, (CharSequence)idpEntityId)) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_ISSUER;
            MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInResponse), errorCode);
            LOGGER.fine(e.getMessage());
            throw e;
        }
        if (!StringUtils.equals((CharSequence)issuerInAssertion, (CharSequence)idpEntityId)) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_ISSUER;
            MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInAssertion), errorCode);
            LOGGER.fine(e.getMessage());
            throw e;
        }
    }

    private void verifyDestination(Response response, String acsUrl) {
        LOGGER.fine("Verifying Destination if present in SAML Response");
        String destInResponse = response.getDestination();
        LOGGER.fine("destInResponse: " + destInResponse + "acsURL: " + acsUrl);
        if (StringUtils.isBlank((CharSequence)destInResponse) || StringUtils.equals((CharSequence)destInResponse, (CharSequence)acsUrl)) {
            return;
        }
        MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_DESTINATION;
        MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, destInResponse), errorCode);
        LOGGER.fine(e.getMessage());
        throw e;
    }

    private void verifyRecipient(Assertion assertion, String acsUrl) {
        LOGGER.fine("Verifying Recipient if present in SAML Response");
        String recipientInResponse = ((SubjectConfirmation)assertion.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData().getRecipient();
        LOGGER.fine("destInResponse: " + recipientInResponse);
        if (StringUtils.isBlank((CharSequence)recipientInResponse) || StringUtils.equals((CharSequence)recipientInResponse, (CharSequence)acsUrl)) {
            return;
        }
        MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_RECIPIENT;
        MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, recipientInResponse), errorCode);
        LOGGER.fine(e.getMessage());
        throw e;
    }

    private void verifyConditions(Assertion assertion, String audienceExpected) {
        LOGGER.fine("Verifying Conditions...");
        Date now = new DateTime().toDate();
        Date notBefore = null;
        Date notOnOrAfter = null;
        long timeDifferenceInBefore = 0L;
        long timeDifferenceInAfter = 0L;
        if (assertion.getConditions().getNotBefore() != null) {
            notBefore = assertion.getConditions().getNotBefore().toDate();
            if (now.before(notBefore)) {
                timeDifferenceInBefore = Math.abs(notBefore.getTime() - now.getTime());
            }
            LOGGER.fine("timeDifferenceInBefore = " + timeDifferenceInBefore);
        }
        if (assertion.getConditions().getNotOnOrAfter() != null) {
            notOnOrAfter = assertion.getConditions().getNotOnOrAfter().toDate();
            if (now.after(notOnOrAfter)) {
                timeDifferenceInAfter = Math.abs(now.getTime() - notOnOrAfter.getTime());
            }
            LOGGER.fine("timeDifferenceNotOnOrAfter = " + timeDifferenceInAfter);
        }
        LOGGER.fine("Verifying TimeStamp Conditions...");
        if (timeDifferenceInAfter > 0L || timeDifferenceInBefore > 0L) {
            MoSAMLException e = new MoSAMLException(MoSAMLException.SAMLErrorCode.NOT_IN_TIMESTAMP);
            LOGGER.fine(MoSAMLException.SAMLErrorCode.NOT_IN_TIMESTAMP.getMessage());
            throw e;
        }
        if (audienceExpected.endsWith("/")) {
            audienceExpected = audienceExpected.substring(0, audienceExpected.length() - 1);
        }
        LOGGER.fine("audienceExpected : " + audienceExpected);
        List audiencesInAssertion = ((AudienceRestriction)assertion.getConditions().getAudienceRestrictions().get(0)).getAudiences();
        for (Audience audience : audiencesInAssertion) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)audience.getAudienceURI(), (CharSequence)audienceExpected)) continue;
            return;
        }
        MoSAMLException e = new MoSAMLException(MoSAMLException.SAMLErrorCode.INVALID_AUDIENCE);
        LOGGER.fine(MoSAMLException.SAMLErrorCode.INVALID_AUDIENCE.getMessage());
        throw e;
    }

    private Boolean verifyCertificate(Response response, Assertion assertion, String x509Certificate) {
        LOGGER.fine("Verifying Certificates.");
        if (x509Certificate != null) {
            try {
                if (!response.isSigned() && !assertion.isSigned()) {
                    MoSAMLException e = new MoSAMLException(MoSAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED);
                    LOGGER.fine(MoSAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED.getMessage());
                    throw e;
                }
                if (response.isSigned()) {
                    LOGGER.fine("Verifying the signature.");
                    return MoSAMLUtils.verifyCertificate((SignableXMLObject)response, x509Certificate);
                }
                if (assertion.isSigned()) {
                    LOGGER.fine("Verifying the assertion.");
                    return MoSAMLUtils.verifyCertificate((SignableXMLObject)assertion, x509Certificate);
                }
                LOGGER.fine("Error occurred while verifying the certificate");
            }
            catch (ValidationException e) {
                this.handleSamlException(MoSAMLException.SAMLErrorCode.INVALID_SIGNATURE, assertion, response);
            }
            catch (NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
                this.handleSamlException(MoSAMLException.SAMLErrorCode.INVALID_CERTIFICATE, assertion, response);
            }
        }
        return false;
    }

    private void handleSamlException(MoSAMLException.SAMLErrorCode errorCode, Assertion assertion, Response response) throws MoSAMLException {
        this.buildExpectedCertificate(errorCode, assertion, response);
        MoSAMLException samlException = new MoSAMLException(this.certificateexpected, errorCode.getResolution(), errorCode);
        LOGGER.fine(samlException.getMessage());
        throw samlException;
    }

    private void buildExpectedCertificate(MoSAMLException.SAMLErrorCode error, Assertion assertion, Response response) {
        try {
            if (assertion.isSigned()) {
                List x509Datas = assertion.getSignature().getKeyInfo().getX509Datas();
                for (X509Data x509Data : x509Datas) {
                    List certificates = x509Data.getX509Certificates();
                    for (X509Certificate certificate : certificates) {
                        this.certificateexpected = certificate.getValue();
                    }
                }
            } else if (response.isSigned()) {
                List x509Datas = response.getSignature().getKeyInfo().getX509Datas();
                for (X509Data x509Data : x509Datas) {
                    List certificates = x509Data.getX509Certificates();
                    for (X509Certificate certificate : certificates) {
                        this.certificateexpected = certificate.getValue();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.fine(e.getMessage());
        }
    }

    private Map<String, String[]> getAttributes(Assertion assertion) {
        LOGGER.fine("Getting attributes from SAML Response");
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        if (assertion.getAttributeStatements().size() > 0) {
            for (Attribute attr : ((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes()) {
                if (attr.getAttributeValues().size() <= 0) continue;
                String[] values = new String[attr.getAttributeValues().size()];
                for (int i = 0; i < attr.getAttributeValues().size(); ++i) {
                    values[i] = ((XMLObject)attr.getAttributeValues().get(i)).getDOM().getTextContent();
                }
                attributes.put(attr.getName(), values);
            }
        }
        return attributes;
    }

    private String buildResolutionMessage(MoSAMLException.SAMLErrorCode error, String found, String expected) {
        StringBuffer errorMsg = new StringBuffer(error.getResolution());
        errorMsg.append(" app was expecting ");
        errorMsg.append(expected);
        errorMsg.append(" but found: ");
        errorMsg.append(found);
        return errorMsg.toString();
    }

    public void createAuthnRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String nonce, MoSAMLPluginSettings settings) {
        try {
            LOGGER.fine("Creating Authentication Request and redirecting user to Idp for authentication");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(settings.getSPEntityID(), settings.getSpAcsUrl(), settings.getSsoUrl(), settings.getNameIDFormat(), BooleanUtils.toBooleanDefaultIfNull((Boolean)settings.getForceAuthn(), (boolean)false), StringUtils.defaultString((String)settings.getAuthnContextClass(), (String)"None"));
            if (StringUtils.equals((CharSequence)settings.getSsoBindingType(), (CharSequence)"HttpPost")) {
                response.setContentType("text/html");
                LOGGER.fine("HTTP-POST Binding selected for SSO");
                if (settings.getSignedRequest()) {
                    authnRequest = (AuthnRequest)MoSAMLUtils.signHttpPostRequest((SignableSAMLObject)authnRequest, settings.getPublicSPCertificate(), settings.getPrivateSPCertificate());
                }
                String encodedAuthnRequest = MoSAMLUtils.base64EncodeRequest((XMLObject)authnRequest, true);
                String form = this.createHttpPostRequestForm(settings.getSsoUrl(), encodedAuthnRequest, nonce);
                LOGGER.fine("form created for post is " + form);
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
                return;
            }
            LOGGER.fine("HTTP-Redirect Binding selected for SSO");
            String encodedAuthnRequest = MoSAMLUtils.base64EncodeRequest((XMLObject)authnRequest, false);
            LOGGER.fine("encodedAuthnRequest: " + encodedAuthnRequest);
            String urlForSignature = this.createRequestQueryParamsForSignature(encodedAuthnRequest, nonce);
            String signature = MoSAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", settings.getPublicSPCertificate(), settings.getPrivateSPCertificate());
            String redirectUrl = "";
            if (settings.getSignedRequest()) {
                redirectUrl = this.createRedirectURL(settings.getSsoUrl(), encodedAuthnRequest, nonce, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", signature, false);
            } else {
                LOGGER.fine("sending relay state " + nonce);
                redirectUrl = this.createUnSignedRedirectURL(settings.getSsoUrl(), encodedAuthnRequest, nonce, false);
            }
            MoSAMLManager.httpRedirect(response, redirectUrl);
        }
        catch (Throwable t) {
            LOGGER.fine("An unknown error occurred while creating the AuthnRequest." + t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private String createHttpPostRequestForm(String ssoUrl, String encodedRequest, String relayState) {
        String form = "<html>\n<head>\n    <script>\n        initiate();\n        function initiate() {\n            var form = document.getElementById('saml-request-form');\n            if(form){\n                form.submit();\n            }else{\n                setTimeout(initiate,50)\n            }\n        }\n    </script>\n    </head>\n\n<body>Please wait...\n<form action= \"" + ssoUrl + "\"  method=\"post\" id=\"saml-request-form\">\n<input type=\"hidden\" name=\"SAMLRequest\" value= \"" + encodedRequest + "\" />\n<input type=\"hidden\" name=\"RelayState\" value= \"" + relayState + "\"/>\n</form>\n</body>\n</html>";
        return form;
    }

    public static void httpRedirect(HttpServletResponse response, String redirectUrl) throws IOException {
        LOGGER.fine("Redirecting user to " + redirectUrl);
        response.sendRedirect(redirectUrl);
    }

    private String createUnSignedRedirectURL(String url, String samlRequestOrResponse, String relayState, Boolean isResponse) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(url);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)url, (CharSequence)"?")) {
            builder.append("?");
        }
        if (isResponse.booleanValue()) {
            builder.append(this.createResponseQueryParamsForSignature(samlRequestOrResponse, relayState));
        } else {
            builder.append(this.createRequestQueryParamsForSignature(samlRequestOrResponse, relayState));
        }
        return builder.toString();
    }

    private String createResponseQueryParamsForSignature(String httpRedirectResponse, String relayState) throws UnsupportedEncodingException {
        LOGGER.fine("Creating response query parameter for signature");
        StringBuffer urlForSignature = new StringBuffer();
        urlForSignature.append("SAMLResponse").append("=").append(URLEncoder.encode(httpRedirectResponse, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=" + relayState);
        urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        return urlForSignature.toString();
    }

    private String createRequestQueryParamsForSignature(String httpRedirectRequest, String relayState) throws UnsupportedEncodingException {
        LOGGER.fine("Creating request query parameter for signature");
        StringBuffer urlForSignature = new StringBuffer();
        urlForSignature.append("SAMLRequest").append("=").append(URLEncoder.encode(httpRedirectRequest, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=");
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            LOGGER.fine("relay state is not blank " + relayState);
            urlForSignature.append(URLEncoder.encode(relayState, StandardCharsets.UTF_8.toString()));
        } else {
            urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        }
        LOGGER.fine(urlForSignature.toString());
        return urlForSignature.toString();
    }

    private String createRedirectURL(String url, String samlRequestOrResponse, String relayState, String sigAlgo, String signature, Boolean isResponse) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(url);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)url, (CharSequence)"?")) {
            builder.append("?");
        }
        if (isResponse.booleanValue()) {
            builder.append(this.createResponseQueryParamsForSignature(samlRequestOrResponse, relayState));
        } else {
            builder.append(this.createRequestQueryParamsForSignature(samlRequestOrResponse, relayState));
        }
        builder.append("&").append("SigAlg").append("=").append(URLEncoder.encode(sigAlgo, "UTF-8")).append("&").append("Signature").append("=").append(URLEncoder.encode(signature, "UTF-8"));
        return builder.toString();
    }
}

