/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions.util;

import hudson.model.Job;
import hudson.model.Run;
import jakarta.annotation.Nullable;
import java.util.Optional;
import jenkins.model.Jenkins;
import lombok.NonNull;

public class JenkinsUtil {
    public static Optional<Run> getBuildByNumberOrLast(@NonNull String fullJobName, @Nullable Integer buildNumber) {
        if (fullJobName == null) {
            throw new NullPointerException("fullJobName is marked non-null but is null");
        }
        return Optional.of(Jenkins.get()).map(jenkins -> (Job)jenkins.getItemByFullName(fullJobName, Job.class)).map(job -> {
            if (buildNumber == null || buildNumber <= 0) {
                return job.getLastBuild();
            }
            return job.getBuildByNumber(buildNumber.intValue());
        });
    }
}

