/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions.util;

import hudson.cli.CLICommand;
import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.FileParameterDefinition;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.PasswordParameterDefinition;
import hudson.model.RunParameterDefinition;
import hudson.model.StringParameterDefinition;
import hudson.model.TextParameterDefinition;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParameterValueFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParameterValueFactory.class);
    public static final String GIT_PARAMETER_DEFINITION = "net.uaznia.lukanus.hudson.plugins.gitparameter.GitParameterDefinition";
    public static final String EXTENDED_CHOICE_PARAMETER_DEFINITION = "com.cwctravel.hudson.plugins.extended_choice_parameter.ExtendedChoiceParameterDefinition";

    public static ParameterValue createParameterValue(ParameterDefinition param, Object inputValue) {
        try {
            if (ParameterValueFactory.isParameterDefinitionOf(param, GIT_PARAMETER_DEFINITION)) {
                return ParameterValueFactory.createGitParameterValue(param, inputValue);
            }
            if (ParameterValueFactory.isParameterDefinitionOf(param, EXTENDED_CHOICE_PARAMETER_DEFINITION)) {
                return ParameterValueFactory.createExtendedChoiceParameterValue(param, inputValue);
            }
            if (param instanceof StringParameterDefinition) {
                return ParameterValueFactory.createStringParameterValue((StringParameterDefinition)param, inputValue);
            }
            if (param instanceof BooleanParameterDefinition) {
                return ParameterValueFactory.createBooleanParameterValue((BooleanParameterDefinition)param, inputValue);
            }
            if (param instanceof ChoiceParameterDefinition) {
                return ParameterValueFactory.createChoiceParameterValue((ChoiceParameterDefinition)param, inputValue);
            }
            if (param instanceof TextParameterDefinition) {
                return ParameterValueFactory.createTextParameterValue((TextParameterDefinition)param, inputValue);
            }
            if (param instanceof PasswordParameterDefinition) {
                return ParameterValueFactory.createPasswordParameterValue((PasswordParameterDefinition)param, inputValue);
            }
            if (param instanceof RunParameterDefinition) {
                return ParameterValueFactory.createRunParameterValue((RunParameterDefinition)param, inputValue);
            }
            if (param instanceof FileParameterDefinition) {
                return ParameterValueFactory.createFileParameterValue((FileParameterDefinition)param, inputValue);
            }
            return ParameterValueFactory.createPluginParameterValue(param, inputValue);
        }
        catch (Exception e) {
            log.warn("Failed to create parameter value for {}: {}", (Object)param.getClass().getSimpleName(), (Object)e.getMessage());
            return null;
        }
    }

    private static ParameterValue createStringParameterValue(StringParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            return param.createValue(String.valueOf(inputValue));
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createBooleanParameterValue(BooleanParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            boolean value = inputValue instanceof Boolean ? (Boolean)inputValue : (inputValue instanceof String ? Boolean.parseBoolean((String)inputValue) : Boolean.parseBoolean(String.valueOf(inputValue)));
            return param.createValue(String.valueOf(value));
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createChoiceParameterValue(ChoiceParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            String value = String.valueOf(inputValue);
            if (param.getChoices().contains(value)) {
                return param.createValue(value);
            }
            log.warn("Invalid choice '{}' for parameter '{}'. Valid choices: {}", new Object[]{value, param.getName(), param.getChoices()});
            return param.getDefaultParameterValue();
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createTextParameterValue(TextParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            return param.createValue(String.valueOf(inputValue));
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createPasswordParameterValue(PasswordParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            String value = String.valueOf(inputValue);
            return param.createValue(value);
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createRunParameterValue(RunParameterDefinition param, Object inputValue) {
        if (inputValue != null) {
            String value = String.valueOf(inputValue);
            return param.createValue(value);
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createFileParameterValue(FileParameterDefinition param, Object inputValue) {
        log.warn("File parameter '{}' is not supported via MCP. File parameters require file uploads.", (Object)param.getName());
        return null;
    }

    private static boolean isParameterDefinitionOf(ParameterDefinition param, String className) {
        for (Class<?> current = param.getClass(); current != null; current = current.getSuperclass()) {
            if (!current.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    private static ParameterValue createGitParameterValue(ParameterDefinition param, Object inputValue) {
        return ParameterValueFactory.createParameterValueViaCli(param, String.valueOf(inputValue));
    }

    private static ParameterValue createExtendedChoiceParameterValue(ParameterDefinition param, Object inputValue) {
        String valuesAsString;
        if (inputValue instanceof List) {
            List l = (List)inputValue;
            valuesAsString = l.stream().map(Object::toString).collect(Collectors.joining(","));
        } else {
            valuesAsString = String.valueOf(inputValue);
        }
        return ParameterValueFactory.createParameterValueViaCli(param, valuesAsString);
    }

    private static ParameterValue createParameterValueViaCli(ParameterDefinition param, String inputValue) {
        String paramTypeName = param.getClass().getSimpleName();
        try {
            if (inputValue == null) {
                return param.getDefaultParameterValue();
            }
            Method method = param.getClass().getMethod("createValue", CLICommand.class, String.class);
            try {
                return (ParameterValue)method.invoke((Object)param, null, inputValue);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                log.warn("{} parameter '{}' rejected value '{}': {}", new Object[]{paramTypeName, param.getName(), inputValue, cause.getMessage()});
                return param.getDefaultParameterValue();
            }
        }
        catch (NoSuchMethodException e) {
            log.warn("{} parameter '{}' missing CLI createValue method; falling back to default", (Object)paramTypeName, (Object)param.getName());
        }
        catch (Exception e) {
            log.warn("Failed to create {} parameter value for '{}': {}", new Object[]{paramTypeName, param.getName(), e.getMessage()});
        }
        return param.getDefaultParameterValue();
    }

    private static ParameterValue createPluginParameterValue(ParameterDefinition param, Object inputValue) {
        try {
            Method method7;
            if (inputValue != null) {
                try {
                    method7 = param.getClass().getMethod("createValue", Object.class);
                    if (method7 != null) {
                        return (ParameterValue)method7.invoke((Object)param, inputValue);
                    }
                }
                catch (NoSuchMethodException method2) {
                    // empty catch block
                }
                try {
                    method7 = param.getClass().getMethod("createValue", String.class);
                    if (method7 != null) {
                        return (ParameterValue)method7.invoke((Object)param, String.valueOf(inputValue));
                    }
                }
                catch (NoSuchMethodException method3) {
                    // empty catch block
                }
                if (inputValue instanceof Boolean) {
                    try {
                        method7 = param.getClass().getMethod("createValue", Boolean.TYPE);
                        if (method7 != null) {
                            return (ParameterValue)method7.invoke((Object)param, inputValue);
                        }
                    }
                    catch (NoSuchMethodException method4) {
                        // empty catch block
                    }
                }
                if (inputValue instanceof List) {
                    try {
                        method7 = param.getClass().getMethod("createValue", List.class);
                        if (method7 != null) {
                            return (ParameterValue)method7.invoke((Object)param, inputValue);
                        }
                    }
                    catch (NoSuchMethodException method5) {
                        // empty catch block
                    }
                }
                if (inputValue instanceof List) {
                    try {
                        List list = (List)inputValue;
                        String[] array = (String[])list.stream().map(String::valueOf).toArray(String[]::new);
                        Method method6 = param.getClass().getMethod("createValue", String[].class);
                        if (method6 != null) {
                            return (ParameterValue)method6.invoke((Object)param, new Object[]{array});
                        }
                    }
                    catch (NoSuchMethodException list) {
                        // empty catch block
                    }
                }
            }
            try {
                method7 = param.getClass().getMethod("getDefaultParameterValue", new Class[0]);
                if (method7 != null) {
                    return (ParameterValue)method7.invoke((Object)param, new Object[0]);
                }
            }
            catch (NoSuchMethodException method7) {
                // empty catch block
            }
            log.warn("Could not create parameter value for plugin parameter type: {}", (Object)param.getClass().getName());
            return null;
        }
        catch (Exception e) {
            log.warn("Failed to create plugin parameter value for {}: {}", (Object)param.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }
}

