/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions;

import hudson.Extension;
import hudson.console.LineTransformationOutputStream;
import hudson.console.PlainTextConsoleOutputStream;
import hudson.model.Run;
import io.jenkins.plugins.mcp.server.McpServerExtension;
import io.jenkins.plugins.mcp.server.annotation.Tool;
import io.jenkins.plugins.mcp.server.annotation.ToolParam;
import io.jenkins.plugins.mcp.server.extensions.util.JenkinsUtil;
import io.jenkins.plugins.mcp.server.extensions.util.SlidingWindow;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.util.SystemProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class BuildLogsExtension
implements McpServerExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuildLogsExtension.class);

    @Tool(description="Retrieves some log lines with pagination for a specific build or the last build of a Jenkins job, as well as a boolean value indicating whether there is more content to retrieve", annotations=@Tool.Annotations(destructiveHint=false))
    public BuildLogResponse getBuildLog(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @ToolParam(description="The build number (optional, if not provided, returns the last build)", required=false) Integer buildNumber, @ToolParam(description="The skip (optional, if not provided, returns from the first line). Negative values function as 'from the end', with -1 meaning starting with the last line", required=false) Long skip, @ToolParam(description="The number of lines to return (optional, if not provided, returns 100 lines), positive values return lines from the start, negative values return lines from the end", required=false) Integer limit) {
        if (limit == null || limit == 0) {
            limit = 100;
        }
        if (skip == null) {
            skip = 0L;
        }
        int limitF = limit;
        long skipF = skip;
        return JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber).map(build -> {
            try {
                return this.getLogLines((Run<?, ?>)build, skipF, limitF);
            }
            catch (Exception e) {
                log.error("Error reading log for job {} build {}", new Object[]{jobFullName, buildNumber, e});
                return null;
            }
        }).orElse(null);
    }

    @Tool(description="Search for log lines matching a pattern in a specific build or the last build of a Jenkins job. Returns matching lines with their line numbers and context.", annotations=@Tool.Annotations(destructiveHint=false))
    public SearchLogResponse searchBuildLog(@ToolParam(description="Job full name of the Jenkins job (e.g., 'folder/job-name')") String jobFullName, @ToolParam(description="The build number (optional, if not provided, searches the last build)", required=false) Integer buildNumber, @ToolParam(description="The search pattern (regex supported)") String pattern, @ToolParam(description="Whether to use regex pattern matching (default: false, uses simple string contains)", required=false) Boolean useRegex, @ToolParam(description="Whether the search should be case-insensitive (default: false)", required=false) Boolean ignoreCase, @ToolParam(description="Maximum number of matches to return (optional, default: 100, max: 1000)", required=false) Integer maxMatches, @ToolParam(description="Number of context lines to show before and after each match (default: 0)", required=false) Integer contextLines) {
        if (pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("Search pattern cannot be null or empty");
        }
        if (useRegex == null) {
            useRegex = false;
        }
        if (ignoreCase == null) {
            ignoreCase = false;
        }
        if (maxMatches == null) {
            maxMatches = 100;
        }
        if (contextLines == null) {
            contextLines = 0;
        }
        maxMatches = Math.min(maxMatches, 1000);
        contextLines = Math.min(Math.max(contextLines, 0), 10);
        boolean useRegexF = useRegex;
        boolean ignoreCaseF = ignoreCase;
        int maxMatchesF = maxMatches;
        int contextLinesF = contextLines;
        return JenkinsUtil.getBuildByNumberOrLast(jobFullName, buildNumber).map(build -> {
            try {
                return this.searchLogLines((Run<?, ?>)build, pattern, useRegexF, ignoreCaseF, maxMatchesF, contextLinesF);
            }
            catch (Exception e) {
                log.error("Error searching log for job {} build {}", new Object[]{jobFullName, buildNumber, e});
                return null;
            }
        }).orElse(null);
    }

    private SearchLogResponse searchLogLines(Run<?, ?> run, String pattern, boolean useRegex, boolean ignoreCase, int maxMatches, int contextLines) throws Exception {
        log.trace("searchLogLines for run {}/{} called with pattern '{}', useRegex={}, ignoreCase={}", new Object[]{run.getParent().getName(), run.getDisplayName(), pattern, useRegex, ignoreCase});
        try (SearchingOutputStream sos = new SearchingOutputStream(pattern, useRegex, ignoreCase, maxMatches, contextLines);){
            run.writeWholeLogTo((OutputStream)new PlainTextConsoleOutputStream((OutputStream)((Object)sos)));
            SearchLogResponse searchLogResponse = new SearchLogResponse(pattern, useRegex, ignoreCase, sos.getMatches().size(), sos.hasMoreMatches, sos.lineNumber, sos.getMatches());
            return searchLogResponse;
        }
    }

    private BuildLogResponse getLogLines(Run<?, ?> run, long skip, int limit) throws Exception {
        int linesNumber;
        boolean negativeLimit;
        log.trace("getLogLines for run {}/{} called with skip {}, limit {}", new Object[]{run.getParent().getName(), run.getDisplayName(), skip, limit});
        int maxLimit = SystemProperties.getInteger((String)(BuildLogsExtension.class.getName() + ".limit.max"), (Integer)10000);
        boolean bl = negativeLimit = limit < 0;
        if (Math.abs(limit) > maxLimit) {
            log.warn("Limit {} is too large, using the default max limit {}", (Object)limit, (Object)maxLimit);
        }
        limit = Math.min(Math.abs(limit), maxLimit);
        if (negativeLimit) {
            limit = -limit;
        }
        long skipInit = skip;
        int limitInit = limit;
        long start = System.currentTimeMillis();
        log.trace("counting lines for run {}", (Object)run.getDisplayName());
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();
             LinesNumberOutputStream out = new LinesNumberOutputStream(os);){
            run.writeWholeLogTo((OutputStream)((Object)out));
            linesNumber = out.lines;
            if (log.isDebugEnabled()) {
                log.debug("counted {} lines in {} ms", (Object)linesNumber, (Object)(System.currentTimeMillis() - start));
            }
        }
        if (skip > 0L && limit < 0) {
            skip = Math.max(0L, skip - (long)Math.abs(limit));
            limit = Math.abs(limit);
        } else if (skip == 0L && negativeLimit) {
            skip = Math.max(0, linesNumber + limit);
            limit = Math.abs(limit);
        } else if (skip < 0L && limit > 0) {
            skip = Math.max(0L, (long)linesNumber + skip);
        } else if (skip < 0L && limit < 0) {
            skip = Math.max(0L, (long)linesNumber + skip - (long)Math.abs(limit));
            limit = Math.abs(limit);
        }
        long actualStartLine = skip + 1L;
        long actualEndLine = Math.min(skip + (long)limit, (long)linesNumber);
        start = System.currentTimeMillis();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            BuildLogResponse buildLogResponse;
            try (SkipLogOutputStream out = new SkipLogOutputStream(os, skip, limit);){
                run.writeWholeLogTo((OutputStream)((Object)out));
                if (log.isDebugEnabled()) {
                    log.debug("call with skip {}, limit {} for linesNumber {} with read with skip {}, limit {}, time to extract: {} ms", new Object[]{skipInit, limitInit, linesNumber, skip, limit, System.currentTimeMillis() - start});
                }
                buildLogResponse = new BuildLogResponse(out.hasMoreContent, os.toString(StandardCharsets.UTF_8).lines().toList(), linesNumber, actualStartLine, actualEndLine);
            }
            return buildLogResponse;
        }
    }

    public record BuildLogResponse(boolean hasMoreContent, List<String> lines, int totalLines, long startLine, long endLine) {
    }

    public record SearchLogResponse(String pattern, boolean useRegex, boolean ignoreCase, int matchCount, boolean hasMoreMatches, long totalLines, List<SearchMatch> matches) {
    }

    static class SearchingOutputStream
    extends LineTransformationOutputStream {
        private final String pattern;
        private final boolean useRegex;
        private final boolean ignoreCase;
        private final int maxMatches;
        private final long contextLines;
        private final SlidingWindow<String> slidingWindow;
        private final List<SearchMatch> openMatches = new ArrayList<SearchMatch>();
        private final List<SearchMatch> closedMatches = new ArrayList<SearchMatch>();
        private boolean hasMoreMatches = false;
        private long lineNumber = 0L;
        private Pattern compiledPattern;

        public SearchingOutputStream(String pattern, boolean useRegex, boolean ignoreCase, int maxMatches, int contextLines) throws IOException {
            this.pattern = pattern;
            this.useRegex = useRegex;
            this.ignoreCase = ignoreCase;
            this.maxMatches = maxMatches;
            this.contextLines = contextLines;
            this.slidingWindow = new SlidingWindow(contextLines);
            if (useRegex) {
                int flags = ignoreCase ? 2 : 0;
                this.compiledPattern = Pattern.compile(pattern, flags);
            }
        }

        protected void eol(byte[] b, int len) {
            ++this.lineNumber;
            String line = new String(b, 0, len, StandardCharsets.UTF_8).trim();
            boolean matched = this.matchLine(line);
            if (matched && this.openMatches.size() + this.closedMatches.size() < this.maxMatches) {
                this.addNewMatch(line);
            } else if (!this.hasMoreMatches && this.openMatches.size() + this.closedMatches.size() >= this.maxMatches) {
                this.hasMoreMatches = matched;
            }
            this.updateOpenMatches(line);
            this.slidingWindow.add(line);
        }

        private boolean matchLine(String line) {
            if (this.useRegex) {
                return this.compiledPattern.matcher(line).find();
            }
            return this.ignoreCase ? line.toLowerCase().contains(this.pattern.toLowerCase()) : line.contains(this.pattern);
        }

        private void addNewMatch(String matchedLine) {
            ArrayList<String> contextLines = new ArrayList<String>(this.slidingWindow.size());
            contextLines.addAll(this.slidingWindow.getRecords());
            long contextStartLine = this.lineNumber - (long)contextLines.size();
            this.openMatches.add(new SearchMatch(this.lineNumber, matchedLine, contextLines, contextStartLine, this.lineNumber));
        }

        private void updateOpenMatches(String line) {
            Iterator<SearchMatch> iterator = this.openMatches.iterator();
            while (iterator.hasNext()) {
                SearchMatch match = iterator.next();
                match.addContextLine(line);
                match.setContextEndLine(this.lineNumber);
                if (this.lineNumber < match.matchedLineNumber + this.contextLines) continue;
                this.closedMatches.add(match);
                iterator.remove();
            }
        }

        public List<SearchMatch> getMatches() {
            ArrayList<SearchMatch> allMatches = new ArrayList<SearchMatch>(this.closedMatches);
            allMatches.addAll(this.openMatches);
            return allMatches;
        }

        public boolean hasMoreMatches() {
            return this.hasMoreMatches;
        }

        public long getTotalLines() {
            return this.lineNumber;
        }
    }

    private static class LinesNumberOutputStream
    extends PlainTextConsoleOutputStream {
        private int lines;

        public LinesNumberOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        protected void eol(byte[] in, int sz) throws IOException {
            ++this.lines;
        }
    }

    private static class SkipLogOutputStream
    extends PlainTextConsoleOutputStream {
        private final long skip;
        private final int limit;
        private long current;
        private boolean hasMoreContent;

        public SkipLogOutputStream(OutputStream out, long skip, int limit) throws IOException {
            super(out);
            this.skip = skip;
            this.limit = limit;
        }

        protected void eol(byte[] in, int sz) throws IOException {
            if (this.current >= this.skip && (long)this.limit > this.current - this.skip) {
                super.eol(in, sz);
            } else if (this.current - this.skip >= (long)this.limit) {
                this.hasMoreContent = true;
            }
            ++this.current;
        }
    }

    public static class SearchMatch {
        private final long matchedLineNumber;
        private final String matchedLine;
        private final List<String> contextLines;
        private final long contextStartLine;
        private long contextEndLine;

        public SearchMatch(long matchedLineNumber, String matchedLine, List<String> contextLines, long contextStartLine, long contextEndLine) {
            this(matchedLineNumber, matchedLine, new ArrayList<String>(contextLines), contextStartLine);
            this.contextEndLine = contextEndLine;
        }

        public void addContextLine(String line) {
            this.contextLines.add(line);
        }

        @Generated
        public long getMatchedLineNumber() {
            return this.matchedLineNumber;
        }

        @Generated
        public String getMatchedLine() {
            return this.matchedLine;
        }

        @Generated
        public List<String> getContextLines() {
            return this.contextLines;
        }

        @Generated
        public long getContextStartLine() {
            return this.contextStartLine;
        }

        @Generated
        public long getContextEndLine() {
            return this.contextEndLine;
        }

        @Generated
        public SearchMatch(long matchedLineNumber, String matchedLine, List<String> contextLines, long contextStartLine) {
            this.matchedLineNumber = matchedLineNumber;
            this.matchedLine = matchedLine;
            this.contextLines = contextLines;
            this.contextStartLine = contextStartLine;
        }

        @Generated
        public void setContextEndLine(long contextEndLine) {
            this.contextEndLine = contextEndLine;
        }
    }
}

