/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.polyspace.jenkins.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.stream.Stream;

public class PolyspaceUtils {
    public static Path copyToTempFile(Path path) throws IOException {
        if (!path.toFile().isDirectory()) {
            Path tempDir = Files.createTempDirectory(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), "polyspace-", new FileAttribute[0]);
            Path filename = path.getFileName();
            if (filename == null) {
                throw new RuntimeException("Cannot work on a path with 0 elements: '" + String.valueOf(path) + "'");
            }
            Path tempFile = Paths.get(tempDir.toString(), filename.toString());
            Files.copy(path, tempFile, new CopyOption[0]);
            return tempFile;
        }
        throw new RuntimeException("Should not be a directory: '" + String.valueOf(path) + "'");
    }

    public static String getFileContent(Path path) throws IOException {
        return Files.readString(path);
    }

    public static void writeContent(Path path, ArrayList<String> content) throws IOException {
        Files.write(path, content, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static long getFileLineCount(Path path) throws IOException {
        long nb;
        try (Stream<String> lines = Files.lines(path);){
            nb = lines.count();
        }
        return nb;
    }
}

