/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.polyspace.jenkins.utils;

import com.mathworks.polyspace.jenkins.utils.PolyspaceUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public class PolyspaceHelpersUtils {
    public static Boolean isOwnerInFile(Path ownerList, String owner) throws IOException {
        if (!ownerList.toFile().exists()) {
            return false;
        }
        String content = PolyspaceUtils.getFileContent(ownerList);
        return content.lines().anyMatch(line -> line.equals(owner));
    }

    public static void appendLineInFile(Path file, String line) throws IOException {
        String lineWithNewLine = line + "\n";
        Files.write(file, lineWithNewLine.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    public static Path getReportOwner(Path report, String owner) {
        if (owner.isEmpty()) {
            return report;
        }
        String reportAsString = report.toString();
        int extensionPos = reportAsString.lastIndexOf(46);
        int separatorPos = reportAsString.lastIndexOf(File.separatorChar);
        if (separatorPos >= extensionPos) {
            return Paths.get(reportAsString + "_" + owner, new String[0]);
        }
        return Paths.get(reportAsString.substring(0, extensionPos) + "_" + owner + reportAsString.substring(extensionPos), new String[0]);
    }

    public static Path getReportOwnerList(Path report) {
        return Paths.get(String.valueOf(report) + ".owners.list", new String[0]);
    }

    public static int reportGetColId(String line, String token) {
        List<String> tokens = Arrays.asList(line.split("\t"));
        int index = tokens.indexOf(token);
        if (index != -1) {
            return index;
        }
        throw new RuntimeException("Title '" + token + "' does not exist");
    }

    public static void reportFilter(Path originalReport, Path filteredReport, String owner, String[] filters) throws IOException {
        int n = 0;
        if (!Files.exists(originalReport, new LinkOption[0])) {
            throw new RuntimeException("Original report '" + String.valueOf(originalReport) + "' does not exist");
        }
        if (filters.length == 0) {
            throw new RuntimeException("Missing filters");
        }
        Path filteredReport_owner = PolyspaceHelpersUtils.getReportOwner(filteredReport, owner);
        if (!owner.isEmpty() && filteredReport_owner.toFile().isDirectory()) {
            throw new RuntimeException("Cannot create filtered report as the directory '" + String.valueOf(filteredReport_owner) + "'");
        }
        Path ownerList = PolyspaceHelpersUtils.getReportOwnerList(filteredReport);
        if (ownerList.toFile().isDirectory()) {
            throw new RuntimeException("Cannot create owner list as the directory '" + String.valueOf(ownerList) + "'");
        }
        String originalReportContent = PolyspaceUtils.getFileContent(originalReport);
        if (originalReportContent.isEmpty()) {
            return;
        }
        try (Scanner originalReportScanner = new Scanner(originalReportContent);){
            boolean addTitle;
            String titleLine = originalReportScanner.nextLine();
            int nCriteria = (filters.length - n) / 2;
            int[] colId = new int[nCriteria];
            String[] criteria = new String[nCriteria];
            for (int id = 0; id < nCriteria; ++id) {
                colId[id] = PolyspaceHelpersUtils.reportGetColId(titleLine, filters[n++]);
                criteria[id] = filters[n++];
            }
            ArrayList<String> filteredReportContent = new ArrayList<String>();
            boolean bl = addTitle = !filteredReport_owner.toFile().exists();
            if (addTitle) {
                filteredReportContent.add(titleLine);
            }
            boolean filteredReportEmpty = true;
            while (originalReportScanner.hasNextLine()) {
                String line = originalReportScanner.nextLine();
                String[] tokens = line.split("\t");
                boolean matching = true;
                for (int id = 0; matching && id < nCriteria; ++id) {
                    matching = tokens[colId[id]].equals(criteria[id]);
                }
                if (!matching) continue;
                filteredReportEmpty = false;
                filteredReportContent.add(line);
            }
            PolyspaceUtils.writeContent(filteredReport_owner, filteredReportContent);
            if (!(filteredReportEmpty || owner.isEmpty() || PolyspaceHelpersUtils.isOwnerInFile(ownerList, owner).booleanValue())) {
                PolyspaceHelpersUtils.appendLineInFile(ownerList, owner);
            }
        }
    }

    public static long getCountFindings(Path report) throws IOException {
        return PolyspaceUtils.getFileLineCount(report) - 1L;
    }

    public static String getReportStatus(Path report, long max) throws IOException {
        long nb = PolyspaceHelpersUtils.getCountFindings(report);
        return nb > max ? "UNSTABLE" : "SUCCESS";
    }

    private static AccessUploadResult getAccessUploadResult(Path output) throws IOException {
        AccessUploadResult result = new AccessUploadResult();
        String content = PolyspaceUtils.getFileContent(output);
        content.lines().filter(line -> line.startsWith("Upload successful for RUN_ID")).findFirst().ifPresent(line -> {
            String[] tokens = line.split(" ");
            result.runId = tokens[4];
            result.projectId = tokens[7];
        });
        return result;
    }

    public static String getAccessResultRunId(Path output) throws IOException {
        AccessUploadResult result = PolyspaceHelpersUtils.getAccessUploadResult(output);
        if (result.runId.isEmpty()) {
            throw new RuntimeException("Cannot find runId in '" + String.valueOf(output) + "'");
        }
        return result.runId;
    }

    public static String getAccessResultProjectId(Path output) throws IOException {
        AccessUploadResult result = PolyspaceHelpersUtils.getAccessUploadResult(output);
        if (result.projectId.isEmpty()) {
            throw new RuntimeException("Cannot find projectId in '" + String.valueOf(output) + "'");
        }
        return result.projectId;
    }

    public static String getAccessResultUrl(Path output, String accessURL) throws IOException {
        AccessUploadResult result = PolyspaceHelpersUtils.getAccessUploadResult(output);
        if (result.projectId.isEmpty()) {
            throw new RuntimeException("Cannot find project url from '" + String.valueOf(output) + "'");
        }
        return accessURL + "/metrics/index.html?a=review&p=" + result.projectId + "&r=" + result.runId;
    }

    public static class AccessUploadResult {
        public String runId;
        public String projectId;

        public AccessUploadResult() {
            this.runId = "";
            this.projectId = "";
        }

        public AccessUploadResult(String r, String p) {
            this.runId = r;
            this.projectId = p;
        }
    }
}

