/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.polyspace.jenkins.config;

import com.mathworks.polyspace.jenkins.config.Messages;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public final class PolyspaceConfigUtils {
    public static final String exeSuffix() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return ".exe";
        }
        return "";
    }

    public static void checkPolyspaceBinFolderExists(String polyspacePath) throws FormValidation {
        File path = new File(polyspacePath);
        if (!path.isDirectory()) {
            throw FormValidation.warning((String)Messages.polyspaceBinNotFound());
        }
    }

    public static void checkPolyspaceBinCommandExists(String polyspaceCommand) throws FormValidation {
        File command = new File(polyspaceCommand);
        if (!command.exists()) {
            throw FormValidation.warning((String)Messages.polyspaceBinNotValid());
        }
    }

    public static FormValidation checkPolyspaceAccess(String polyspacePath, String user, String password, String protocol, String host, String port) {
        String polyspaceCmd = polyspacePath + File.separator + "polyspace-access" + PolyspaceConfigUtils.exeSuffix();
        try {
            PolyspaceConfigUtils.checkPolyspaceBinFolderExists(polyspacePath);
            PolyspaceConfigUtils.checkPolyspaceBinCommandExists(polyspaceCmd);
        }
        catch (FormValidation validation) {
            return validation;
        }
        ArrayList<String> Access = new ArrayList<String>();
        Access.add(polyspaceCmd);
        Access.add("-login");
        Access.add(user);
        Access.add("-encrypted-password");
        Access.add(password);
        if (StringUtils.isNotEmpty((CharSequence)protocol)) {
            Access.add("-protocol");
            Access.add(protocol);
        }
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            Access.add("-host");
            Access.add(host);
        }
        if (StringUtils.isNotEmpty((CharSequence)port)) {
            Access.add("-port");
            Access.add(port);
        }
        Access.add("-list-project");
        String commandString = StringUtils.join(Access, (char)' ');
        if (PolyspaceConfigUtils.checkPolyspaceCommand(Access).booleanValue()) {
            return FormValidation.ok((String)Messages.polyspaceCorrectConfig());
        }
        return FormValidation.error((String)(Messages.polyspaceAccessWrongConfig() + " '" + commandString + "'"));
    }

    public static Boolean checkPolyspaceCommand(List<String> Command) {
        boolean testOK = false;
        try {
            ProcessBuilder pb = new ProcessBuilder(Command);
            Process p = pb.start();
            BufferedReader inputBuffer = new BufferedReader(new InputStreamReader(p.getInputStream(), Mailer.descriptor().getCharset()));
            BufferedReader errorBuffer = new BufferedReader(new InputStreamReader(p.getErrorStream(), Mailer.descriptor().getCharset()));
            boolean processRunning = true;
            while (processRunning) {
                while (inputBuffer.ready()) {
                    inputBuffer.readLine();
                }
                while (errorBuffer.ready()) {
                    errorBuffer.readLine();
                }
                try {
                    int exitValue = p.exitValue();
                    testOK = exitValue == 0;
                    processRunning = false;
                }
                catch (IllegalThreadStateException itse) {
                    Thread.sleep(100L);
                }
            }
            inputBuffer.close();
            errorBuffer.close();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return testOK;
    }

    public static FormValidation doCheckProtocol(String value) {
        if (!value.equals("http") && !value.equals("https")) {
            return FormValidation.error((String)Messages.wrongProtocol());
        }
        return FormValidation.ok();
    }

    public static FormValidation doCheckPort(String value) {
        if (StringUtils.isNumeric((CharSequence)value)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.portMustBeANumber());
    }

    public static FormValidation doCheckFilename(String value) {
        if (!value.isEmpty()) {
            if (value.charAt(0) == '/' || value.charAt(0) == '\\') {
                return FormValidation.error((String)Messages.absoluteDirectoryForbidden());
            }
            if (value.contains("..")) {
                return FormValidation.error((String)Messages.previousDirectoryForbidden());
            }
            return FormValidation.ok();
        }
        return FormValidation.ok();
    }
}

