/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.polyspace.jenkins;

import com.mathworks.polyspace.jenkins.PolyspaceBuildWrapper;
import com.mathworks.polyspace.jenkins.config.Messages;
import com.mathworks.polyspace.jenkins.config.PolyspaceConfigUtils;
import com.mathworks.polyspace.jenkins.utils.PolyspaceHelpersUtils;
import com.mathworks.polyspace.jenkins.utils.PolyspaceUtils;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.annotation.Nonnull;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class PolyspacePostBuildActions
extends Notifier
implements SimpleBuildStep {
    private Boolean sendToRecipients;
    private String recipients;
    private String fileToAttach;
    private String mailSubject;
    private String mailBody;
    private Boolean sendToOwners;
    private String queryBaseName;
    private String mailSubjectBaseName;
    private String mailBodyBaseName;
    private String uniqueRecipients;
    private static Pattern ADDRESS_PATTERN = Pattern.compile("\\s*([^<]*)<([^>]+)>\\s*");

    @DataBoundConstructor
    public PolyspacePostBuildActions() {
    }

    @DataBoundSetter
    public void setSendToRecipients(Boolean sendToRecipients) {
        this.sendToRecipients = sendToRecipients;
    }

    @DataBoundSetter
    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    @DataBoundSetter
    public void setFileToAttach(String fileToAttach) {
        this.fileToAttach = fileToAttach;
    }

    @DataBoundSetter
    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    @DataBoundSetter
    public void setMailBody(String mailBody) {
        this.mailBody = mailBody;
    }

    @DataBoundSetter
    public void setSendToOwners(Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
    }

    @DataBoundSetter
    public void setQueryBaseName(String queryBaseName) {
        this.queryBaseName = queryBaseName;
    }

    @DataBoundSetter
    public void setMailSubjectBaseName(String mailSubjectBaseName) {
        this.mailSubjectBaseName = mailSubjectBaseName;
    }

    @DataBoundSetter
    public void setMailBodyBaseName(String mailBodyBaseName) {
        this.mailBodyBaseName = mailBodyBaseName;
    }

    @DataBoundSetter
    public void setUniqueRecipients(String uniqueRecipients) {
        this.uniqueRecipients = uniqueRecipients;
    }

    private JenkinsLocationConfiguration getJenkinsLocationConfiguration() {
        JenkinsLocationConfiguration jlc = JenkinsLocationConfiguration.get();
        if (jlc == null) {
            throw new IllegalStateException("JenkinsLocationConfiguration not available");
        }
        return jlc;
    }

    public void sendMail(@QueryParameter String sendMailTo, @QueryParameter String subject, @QueryParameter String text, @QueryParameter String attachSource, @QueryParameter String attachName) throws IOException {
        try {
            String charset = Mailer.descriptor().getCharset();
            MimeMessage msg = new MimeMessage(Mailer.descriptor().createSession());
            msg.setSubject(subject, charset);
            msg.setFrom((Address)PolyspacePostBuildActions.stringToAddress(this.getJenkinsLocationConfiguration().getAdminAddress(), charset));
            String replyToAddress = Mailer.descriptor().getReplyToAddress();
            if (StringUtils.isNotBlank((String)replyToAddress)) {
                msg.setReplyTo(new Address[]{PolyspacePostBuildActions.stringToAddress(replyToAddress, charset)});
            }
            msg.setSentDate(new Date());
            StringTokenizer tokens = new StringTokenizer(sendMailTo, " ,;");
            while (tokens.hasMoreTokens()) {
                msg.addRecipient(Message.RecipientType.TO, (Address)PolyspacePostBuildActions.stringToAddress(tokens.nextToken(), charset));
            }
            MimeMultipart multipart = new MimeMultipart();
            if (!attachName.isEmpty()) {
                File file = new File(attachSource);
                if (file.length() > 0xA00000L) {
                    text = (String)text + "\n\nSize of the attached file is too large  -  Not attached\n";
                } else {
                    MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(attachSource);
                    attachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    attachmentBodyPart.setFileName(attachName);
                    multipart.addBodyPart((BodyPart)attachmentBodyPart);
                }
            }
            MimeBodyPart textBodyPart = new MimeBodyPart();
            textBodyPart.setText((String)text, charset);
            multipart.addBodyPart((BodyPart)textBodyPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private String getFilenameOwner(String name, String owner, FilePath workspace) throws IOException {
        String fileName = String.valueOf(workspace) + File.separator;
        fileName = owner.isEmpty() ? fileName + name : fileName + name + String.valueOf(PolyspaceHelpersUtils.getReportOwner(Paths.get(name, new String[0]), owner));
        return Files.readString(Paths.get(fileName, new String[0]));
    }

    private String generateMailBody(String body, String owner, String attachName, String attachSource, FilePath workspace, Run<?, ?> build) {
        try {
            if (body != null && !body.isEmpty()) {
                return this.getFilenameOwner(body, owner, workspace);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object text = "";
        text = owner.isEmpty() ? (String)text + "General email sent by Polyspace Jenkins Plugin\n\n" : (String)text + "Dear " + owner + ",\nPlease find attached the findings you own.\n\n";
        if (!attachName.isEmpty()) {
            text = (String)text + "Please check attached file " + attachName + "\n";
            try {
                text = (String)text + "It contains " + PolyspaceHelpersUtils.getCountFindings(Paths.get(attachSource, new String[0])) + " finding(s)\n";
            }
            catch (Exception e) {
                text = (String)text + "Cannot count nb of findings";
            }
        } else if (!attachSource.isEmpty()) {
            text = (String)text + "Warning: Could not attach " + attachSource + "\n";
        }
        text = (String)text + "\n";
        text = (String)text + "Check Jenkins console output at " + this.getJenkinsLocationConfiguration().getUrl() + build.getUrl() + "\n";
        text = (String)text + "Polyspace configuration is using\n";
        if (!PolyspaceBuildWrapper.descriptor().getPolyspaceAccessURL().equals("POLYSPACE_ACCESS_URL_IS_UNSET")) {
            text = (String)text + "- Polyspace Access " + PolyspaceBuildWrapper.descriptor().getPolyspaceAccessURL() + "\n";
        }
        return text;
    }

    private String generateMailSubject(String subject, String owner, FilePath workspace, Run<?, ?> build) {
        try {
            if (subject != null && !subject.isEmpty()) {
                return this.getFilenameOwner(subject, owner, workspace);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object text = "";
        text = (String)text + "Polyspace Jenkins Plugin";
        text = (String)text + " - " + build.getFullDisplayName();
        text = (String)text + " - " + String.valueOf(build.getResult());
        text = owner.isEmpty() ? (String)text + " - General Email" : (String)text + " - Email to Finding Owners";
        return text;
    }

    private String getFileFromAgent(FilePath workspace, String fileToAttach) throws IOException, InterruptedException {
        FilePath fileOnAgent = workspace.child(fileToAttach);
        if (fileOnAgent.exists()) {
            Path tempDir = Files.createTempDirectory(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), "polyspace-", new FileAttribute[0]);
            File fileOnController = new File(tempDir.toFile(), fileOnAgent.getName());
            fileOnAgent.copyTo(new FilePath(fileOnController));
            return fileOnController.toString();
        }
        return "";
    }

    private void sendToRecipients(Run<?, ?> build, FilePath workspace) throws IOException, InterruptedException {
        String attachName;
        String attachSource;
        FormValidation fileToAttachValidation = PolyspaceConfigUtils.doCheckFilename(this.fileToAttach);
        if (fileToAttachValidation == FormValidation.ok()) {
            attachSource = "";
            attachName = "";
            if (this.fileToAttach != null && !this.fileToAttach.isEmpty()) {
                attachSource = this.getFileFromAgent(workspace, this.fileToAttach);
                attachName = new File(attachSource).getName();
            }
        } else {
            String msg = Messages.errorSendingMail() + " " + fileToAttachValidation.getMessage();
            msg = msg + " in Attachment Filename ('" + this.fileToAttach + "')";
            throw new RuntimeException(msg);
        }
        String subject = this.generateMailSubject(this.mailSubject, "", workspace, build);
        String body = this.generateMailBody(this.mailBody, "", attachName, attachSource, workspace, build);
        this.sendMail(this.recipients, subject, body, attachSource, attachName);
    }

    private void sendToOwners(Run<?, ?> build, FilePath workspace) throws IOException, InterruptedException {
        String ownerList = this.getFileFromAgent(workspace, PolyspaceHelpersUtils.getReportOwnerList(Paths.get(this.queryBaseName, new String[0])).toString());
        if (!ownerList.isEmpty()) {
            String ownerListContent = PolyspaceUtils.getFileContent(Paths.get(ownerList, new String[0]));
            try (Scanner ownerListScanner = new Scanner(ownerListContent);){
                while (ownerListScanner.hasNextLine()) {
                    String owner = ownerListScanner.nextLine();
                    String recipient = this.uniqueRecipients.isEmpty() ? owner : this.uniqueRecipients;
                    String attachSource = this.getFileFromAgent(workspace, PolyspaceHelpersUtils.getReportOwner(Paths.get(this.queryBaseName, new String[0]), owner).toString());
                    String attachName = new File(attachSource).getName();
                    String subject = this.generateMailSubject(this.mailSubjectBaseName, owner, workspace, build);
                    String body = this.generateMailBody(this.mailBodyBaseName, owner, attachName, attachSource, workspace, build);
                    this.sendMail(recipient, subject, body, attachSource, attachName);
                }
            }
        }
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        if (this.sendToRecipients.booleanValue() && this.recipients != null && !this.recipients.isEmpty()) {
            this.sendToRecipients(build, workspace);
        }
        if (this.sendToOwners.booleanValue() && this.queryBaseName != null && !this.queryBaseName.isEmpty()) {
            this.sendToOwners(build, workspace);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Nonnull
    public static InternetAddress stringToAddress(@Nonnull String strAddress, @Nonnull String charset) throws AddressException, UnsupportedEncodingException {
        Matcher m = ADDRESS_PATTERN.matcher(strAddress);
        if (!m.matches()) {
            return new InternetAddress(strAddress);
        }
        String personal = m.group(1);
        String address = m.group(2);
        return new InternetAddress(address, personal, charset);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.polyspaceNotification();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckFileToAttach(@QueryParameter String fileToAttach) {
            return PolyspaceConfigUtils.doCheckFilename(fileToAttach);
        }
    }
}

