/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.polyspace.jenkins;

import com.mathworks.polyspace.jenkins.utils.PolyspaceHelpersUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class PolyspaceHelpers {
    private static void reportFilter(String[] arg) throws IOException, RuntimeException {
        if (arg.length < 5) {
            System.out.println("Usage: ps_helper -report-filter <original_report> <filtered_report> [<owner>] [<title> <value>]+");
            return;
        }
        int n = 0;
        int n2 = ++n;
        Path originalReport = Paths.get(arg[n2], new String[0]);
        int n3 = ++n;
        ++n;
        Path filteredReport = Paths.get(arg[n3], new String[0]);
        String owner = arg.length % 2 == 0 ? arg[n++] : "";
        String[] filters = Arrays.copyOfRange(arg, n, arg.length);
        PolyspaceHelpersUtils.reportFilter(originalReport, filteredReport, owner, filters);
    }

    private static void printRunId(String[] arg) throws IOException, RuntimeException {
        if (arg.length != 2) {
            System.out.println("Usage: ps_helper -print-runid <access upload output>");
            return;
        }
        System.out.println(PolyspaceHelpersUtils.getAccessResultRunId(Paths.get(arg[1], new String[0])));
    }

    private static void printProjectId(String[] arg) throws IOException, RuntimeException {
        if (arg.length != 2) {
            System.out.println("Usage: ps_helper -print-projectid <access upload output>");
            return;
        }
        System.out.println(PolyspaceHelpersUtils.getAccessResultProjectId(Paths.get(arg[1], new String[0])));
    }

    private static void printProjectUrl(String[] arg) throws IOException, RuntimeException {
        if (arg.length != 3) {
            System.out.println("Usage: ps_helper -print-projecturl <access upload output> <access_url>");
            return;
        }
        System.out.println(PolyspaceHelpersUtils.getAccessResultUrl(Paths.get(arg[1], new String[0]), arg[2]));
    }

    private static void reportStatus(String[] arg) throws IOException, NumberFormatException {
        if (arg.length != 3) {
            System.out.println("Usage: ps_helper -report-status <report> <nb_to_fail>");
            return;
        }
        System.out.println(PolyspaceHelpersUtils.getReportStatus(Paths.get(arg[1], new String[0]), Long.parseLong(arg[2])));
    }

    private static void reportCountFindings(String[] arg) throws IOException, NumberFormatException {
        if (arg.length != 2) {
            System.out.println("Usage: ps_helper -report-count-findings <report>");
            return;
        }
        System.out.println(PolyspaceHelpersUtils.getCountFindings(Paths.get(arg[1], new String[0])));
    }

    public static void main(String[] arg) throws IOException, RuntimeException, NumberFormatException {
        boolean usage = false;
        if (arg.length == 0) {
            usage = true;
        } else if (arg[0].equals("-report-filter") || arg[0].equals("report_filter")) {
            PolyspaceHelpers.reportFilter(arg);
        } else if (arg[0].equals("-report-status") || arg[0].equals("report_status")) {
            PolyspaceHelpers.reportStatus(arg);
        } else if (arg[0].equals("-report-count-findings") || arg[0].equals("report_count_findings")) {
            PolyspaceHelpers.reportCountFindings(arg);
        } else if (arg[0].equals("-print-runid") || arg[0].equals("print_runid")) {
            PolyspaceHelpers.printRunId(arg);
        } else if (arg[0].equals("-print-projectid") || arg[0].equals("print_projectid")) {
            PolyspaceHelpers.printProjectId(arg);
        } else if (arg[0].equals("-print-projecturl") || arg[0].equals("print_projecturl")) {
            PolyspaceHelpers.printProjectUrl(arg);
        } else {
            usage = true;
        }
        if (usage) {
            String[] empty = new String[]{};
            PolyspaceHelpers.reportFilter(empty);
            PolyspaceHelpers.reportStatus(empty);
            PolyspaceHelpers.reportCountFindings(empty);
            PolyspaceHelpers.printRunId(empty);
            PolyspaceHelpers.printProjectId(empty);
            PolyspaceHelpers.printProjectUrl(empty);
        }
    }
}

