/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.polyspace.jenkins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.mathworks.polyspace.jenkins.config.Messages;
import com.mathworks.polyspace.jenkins.config.PolyspaceAccessConfig;
import com.mathworks.polyspace.jenkins.config.PolyspaceBinConfig;
import com.mathworks.polyspace.jenkins.config.PolyspaceConfigUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildWrapper;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.core.Authentication;

public class PolyspaceBuildWrapper
extends SimpleBuildWrapper {
    private String serverConfig = null;
    private String polyspaceAccessCredentialId = null;
    private String binConfig = null;

    @DataBoundConstructor
    public PolyspaceBuildWrapper() {
    }

    @DataBoundSetter
    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    @DataBoundSetter
    public void setPolyspaceAccessCredentialId(String polyspaceAccessCredentialId) {
        this.polyspaceAccessCredentialId = polyspaceAccessCredentialId;
    }

    @DataBoundSetter
    public void setBinConfig(String binConfig) {
        this.binConfig = binConfig;
    }

    public String getValue(String value, String default_value) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        return default_value;
    }

    private void update_access(SimpleBuildWrapper.Context context, PolyspaceAccessConfig server, String user, String password) {
        if (server == null || server.getPolyspaceAccessName().equals(PolyspaceBuildWrapper.getUnsetValue())) {
            context.env("POLYSPACE_ACCESS_PROTOCOL", "POLYSPACE_ACCESS_PROTOCOL IS UNSET");
            context.env("POLYSPACE_ACCESS_HOST", "POLYSPACE_ACCESS_HOST IS UNSET");
            context.env("POLYSPACE_ACCESS_PORT", "POLYSPACE_ACCESS_PORT IS UNSET");
            context.env("POLYSPACE_ACCESS_URL", "POLYSPACE_ACCESS_URL IS UNSET");
            PolyspaceBuildWrapper.descriptor().setPolyspaceAccessURL("");
            context.env("ps_helper_access", "ps_helper_access IS UNSET");
        } else {
            String protocol = this.getValue(server.getPolyspaceAccessProtocol(), "https");
            String host = this.getValue(server.getPolyspaceAccessHost(), "localhost");
            String port = this.getValue(server.getPolyspaceAccessPort(), "9443");
            String url = protocol + "://" + host + ":" + port;
            context.env("POLYSPACE_ACCESS_PROTOCOL", protocol);
            context.env("POLYSPACE_ACCESS_HOST", host);
            context.env("POLYSPACE_ACCESS_PORT", port);
            context.env("POLYSPACE_ACCESS_URL", url);
            PolyspaceBuildWrapper.descriptor().setPolyspaceAccessURL(url);
            if (!StringUtils.isEmpty((CharSequence)user) && !StringUtils.isEmpty((CharSequence)password)) {
                Object polypaceAccess = "polyspace-access -tmp-dir tmp-dir";
                polypaceAccess = (String)polypaceAccess + " -protocol " + protocol + " -host " + host + " -port " + port;
                polypaceAccess = (String)polypaceAccess + " -login " + user + " -encrypted-password " + password;
                context.env("ps_helper_access", (String)polypaceAccess);
            } else {
                context.env("ps_helper_access", "ps_helper_access IS UNSET");
            }
        }
    }

    private void update_global(SimpleBuildWrapper.Context context, PolyspaceBinConfig bin, EnvVars initialEnvironment) {
        Object path = (String)initialEnvironment.get((Object)"PATH");
        String jenkins_home = (String)initialEnvironment.get((Object)"JENKINS_HOME");
        if (SystemUtils.IS_OS_WINDOWS) {
            path = jenkins_home + "\\jre\\bin" + File.pathSeparator + (String)path;
        }
        if (bin != null) {
            path = bin.getPolyspacePath() + File.pathSeparator + (String)path;
            context.env("POLYSPACE_BIN", bin.getPolyspacePath());
        } else {
            context.env("POLYSPACE_BIN", "POLYSPACE_BIN_IS_UNSET");
        }
        context.env("PATH", (String)path);
        Object polyspaceJar = jenkins_home + File.separator + "plugins" + File.separator + "mathworks-polyspace" + File.separator + "WEB-INF" + File.separator + "lib" + File.separator + "mathworks-polyspace.jar";
        polyspaceJar = SystemUtils.IS_OS_WINDOWS ? "\"" + (String)polyspaceJar + "\"" : ((String)polyspaceJar).replace(" ", "\\ ");
        context.env("ps_helper", "java -cp " + (String)polyspaceJar + " com.mathworks.polyspace.jenkins.PolyspaceHelpers");
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        this.update_access(context, this.getDescriptor().getServerConfig(this.serverConfig), PolyspaceBuildWrapper.getPolyspaceAccessUser(this.getPolyspaceAccessCredentialId()), PolyspaceBuildWrapper.getPolyspaceAccessPassword(this.getPolyspaceAccessCredentialId()));
        this.update_global(context, this.getDescriptor().getBinConfig(this.binConfig), initialEnvironment);
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public String getPolyspaceAccessCredentialId() {
        return this.polyspaceAccessCredentialId;
    }

    public String getBinConfig() {
        return this.binConfig;
    }

    public static final String getUnsetValue() {
        return "<unset>";
    }

    public static String getPolyspaceAccessUser(String credentialId) {
        return PolyspaceBuildWrapper.retrieveCredentialInfo(true, credentialId);
    }

    public static String getPolyspaceAccessPassword(String credentialId) {
        return PolyspaceBuildWrapper.retrieveCredentialInfo(false, credentialId);
    }

    private static String retrieveCredentialInfo(boolean getUsername, String credentialId) {
        StandardCredentials credentials;
        if (!StringUtils.isEmpty((CharSequence)credentialId) && (credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(StandardCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId))) instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials c = (UsernamePasswordCredentials)credentials;
            if (getUsername) {
                return c.getUsername();
            }
            return c.getPassword().getPlainText();
        }
        return "";
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static DescriptorImpl descriptor() {
        Jenkins jenkins = Jenkins.get();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins instance is not ready");
        }
        return (DescriptorImpl)jenkins.getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private CopyOnWriteList<PolyspaceAccessConfig> polyspaceAccessConfigs = new CopyOnWriteList();
        private CopyOnWriteList<PolyspaceBinConfig> polyspaceBinConfigs = new CopyOnWriteList();
        String polyspaceAccessURL;

        String getPolyspaceAccessURL() {
            return this.polyspaceAccessURL;
        }

        void setPolyspaceAccessURL(String polyspaceAccessURL) {
            this.polyspaceAccessURL = polyspaceAccessURL;
        }

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.polyspaceBuildWrapperDisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.polyspaceAccessConfigs.replaceBy((Collection)req.bindJSONToList(PolyspaceAccessConfig.class, formData.get("polyspaceAccessConfigs")));
            this.polyspaceBinConfigs.replaceBy((Collection)req.bindJSONToList(PolyspaceBinConfig.class, formData.get("polyspaceBinConfigs")));
            this.save();
            return super.configure(req, formData);
        }

        public void addPolyspaceBinConfig(PolyspaceBinConfig value) {
            this.polyspaceBinConfigs.add((Object)value);
        }

        public PolyspaceBinConfig[] getpolyspaceBinConfigs() {
            return (PolyspaceBinConfig[])this.polyspaceBinConfigs.toArray((Object[])new PolyspaceBinConfig[0]);
        }

        public PolyspaceBinConfig getBinConfig(String name) {
            if (name == null) {
                return null;
            }
            for (PolyspaceBinConfig config : this.polyspaceBinConfigs) {
                if (config.getName() == null || !config.getName().equals(name)) continue;
                return config;
            }
            return null;
        }

        public void addPolyspaceAccessConfig(PolyspaceAccessConfig value) {
            this.polyspaceAccessConfigs.add((Object)value);
        }

        public PolyspaceAccessConfig[] getpolyspaceAccessConfigs() {
            return (PolyspaceAccessConfig[])this.polyspaceAccessConfigs.toArray((Object[])new PolyspaceAccessConfig[0]);
        }

        public PolyspaceAccessConfig getServerConfig(String name) {
            if (name == null) {
                return null;
            }
            for (PolyspaceAccessConfig config : this.polyspaceAccessConfigs) {
                if (config.getPolyspaceAccessName() == null || !config.getPolyspaceAccessName().equals(name)) continue;
                return config;
            }
            return null;
        }

        public ListBoxModel doFillServerConfigItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(PolyspaceBuildWrapper.getUnsetValue());
            for (PolyspaceAccessConfig config : this.polyspaceAccessConfigs) {
                items.add(config.getPolyspaceAccessName());
            }
            return items;
        }

        public ListBoxModel doFillBinConfigItems() {
            ListBoxModel items = new ListBoxModel();
            for (PolyspaceBinConfig config : this.polyspaceBinConfigs) {
                items.add(config.getName());
            }
            return items;
        }

        public ListBoxModel doFillPolyspaceAccessCredentialIdItems(@AncestorInPath Jenkins context) {
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)context, StandardUsernamePasswordCredentials.class, new ArrayList(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)}));
        }

        public FormValidation doCheckPolyspaceAccess(@AncestorInPath Item item, @QueryParameter String serverConfig, @QueryParameter String polyspaceAccessCredentialId, @QueryParameter String binConfig) throws IOException, InterruptedException {
            if (item == null) {
                return FormValidation.error((String)Messages.internalError());
            }
            item.checkPermission(Item.CONFIGURE);
            PolyspaceBinConfig bin = this.getBinConfig(binConfig);
            PolyspaceAccessConfig server = this.getServerConfig(serverConfig);
            if (server == null) {
                return FormValidation.warning((String)"Polyspace Access Configuration is not provided");
            }
            String user = PolyspaceBuildWrapper.getPolyspaceAccessUser(polyspaceAccessCredentialId);
            String password = PolyspaceBuildWrapper.getPolyspaceAccessPassword(polyspaceAccessCredentialId);
            if (StringUtils.isEmpty((CharSequence)user) || StringUtils.isEmpty((CharSequence)password)) {
                return FormValidation.error((String)"Missing login / password");
            }
            String protocol = server.getPolyspaceAccessProtocol();
            String host = server.getPolyspaceAccessHost();
            String port = server.getPolyspaceAccessPort();
            return PolyspaceConfigUtils.checkPolyspaceAccess(bin.getPolyspacePath(), user, password, protocol, host, port);
        }
    }
}

