/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kubernetes.ephemeral;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class ImageReference {
    private static final Pattern IMAGE_REF_PATTERN = Pattern.compile("^(?<Name>(?<=^)(?:(?<Domain>(?:(?:localhost|[\\w-]+(?:\\.[\\w-]+)+)(?::\\d+)?)|\\w+:\\d+)/)?/?(?<Namespace>(?:(?:[a-z0-9]+(?:(?:[._]|__|-*)[a-z0-9]+)*)/)*)(?<Repo>[a-z0-9-]+))[:@]?(?<Reference>(?<=:)(?<Tag>\\w[\\w.-]{0,127})|(?<=@)(?<Digest>[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*:[0-9A-Fa-f]{32,}))?");
    private final String domain;
    private final String path;
    private final String tag;
    private final String digest;
    private final String name;
    private final String reference;

    public static Optional<ImageReference> parse(@NonNull String reference) {
        Matcher matcher;
        String digest = null;
        String[] parts = StringUtils.split((String)reference, (char)'@');
        if (parts.length == 2) {
            reference = parts[0];
            digest = parts[1];
        }
        if ((matcher = IMAGE_REF_PATTERN.matcher(reference)).matches()) {
            String tag;
            String domain = matcher.group("Domain");
            if (domain == null) {
                domain = "docker.io";
            }
            Object name = matcher.group("Repo");
            String namespace = matcher.group("Namespace");
            if (StringUtils.isEmpty((CharSequence)namespace) && Strings.CS.equals(domain, "docker.io")) {
                namespace = "library/";
            }
            if (!StringUtils.isEmpty((CharSequence)namespace)) {
                name = namespace + (String)name;
            }
            if (StringUtils.isEmpty((CharSequence)(tag = matcher.group("Tag"))) && StringUtils.isEmpty((CharSequence)digest)) {
                tag = "latest";
            }
            return Optional.of(new ImageReference(domain, (String)name, tag, digest));
        }
        return Optional.empty();
    }

    private ImageReference(@NonNull String domain, @NonNull String path, @Nullable String tag, @Nullable String digest) {
        this.domain = domain;
        this.path = path;
        this.tag = tag;
        this.digest = digest;
        Object ref = this.name = domain + "/" + path;
        if (tag != null) {
            ref = (String)ref + ":" + tag;
        }
        if (digest != null) {
            ref = (String)ref + "@" + digest;
        }
        this.reference = ref;
    }

    @NonNull
    public String getDomain() {
        return this.domain;
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTag() {
        return this.tag;
    }

    @Nullable
    public String getDigest() {
        return this.digest;
    }

    @NonNull
    public String getReference() {
        return this.reference;
    }

    public String toString() {
        return this.reference;
    }
}

