/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm.koji.client;

import hudson.FilePath;
import hudson.plugins.scm.koji.FakeKojiXmlRpcApi;
import hudson.plugins.scm.koji.KojiBuildProvider;
import hudson.plugins.scm.koji.KojiXmlRpcApi;
import hudson.plugins.scm.koji.LoggerHelp;
import hudson.plugins.scm.koji.RealKojiXmlRpcApi;
import hudson.plugins.scm.koji.client.BuildMatcher;
import hudson.plugins.scm.koji.client.FakeKojiBuildMatcher;
import hudson.plugins.scm.koji.client.KojiBuildMatcher;
import hudson.plugins.scm.koji.model.Build;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.util.List;
import java.util.function.Predicate;
import org.jenkinsci.remoting.RoleChecker;

public class KojiListBuilds
implements FilePath.FileCallable<Build> {
    private final List<KojiBuildProvider> kojiBuildProviders;
    private final KojiXmlRpcApi kojiXmlRpcApi;
    private final Predicate<String> notProcessedNvrPredicate;
    private final int maxPreviousBuilds;
    private final LoggerHelp logger;

    KojiListBuilds(List<KojiBuildProvider> kojiBuildProviders, KojiXmlRpcApi kojiXmlRpcApi, Predicate<String> notProcessedNvrPredicate, int maxPreviousBuilds) {
        this(kojiBuildProviders, kojiXmlRpcApi, notProcessedNvrPredicate, maxPreviousBuilds, null);
    }

    public KojiListBuilds(List<KojiBuildProvider> kojiBuildProviders, KojiXmlRpcApi kojiXmlRpcApi, Predicate<String> notProcessedNvrPredicate, int maxPreviousBuilds, LoggerHelp logger) {
        this.kojiBuildProviders = kojiBuildProviders;
        this.kojiXmlRpcApi = kojiXmlRpcApi;
        this.notProcessedNvrPredicate = notProcessedNvrPredicate;
        this.maxPreviousBuilds = maxPreviousBuilds;
        this.logger = logger;
    }

    public Build invoke(File workspace, VirtualChannel channel) {
        BuildMatcher buildMatcher;
        if (this.kojiXmlRpcApi instanceof RealKojiXmlRpcApi) {
            buildMatcher = new KojiBuildMatcher(this.kojiBuildProviders, this.notProcessedNvrPredicate, this.maxPreviousBuilds, (RealKojiXmlRpcApi)this.kojiXmlRpcApi, this.logger);
        } else if (this.kojiXmlRpcApi instanceof FakeKojiXmlRpcApi) {
            buildMatcher = new FakeKojiBuildMatcher(this.kojiBuildProviders, this.notProcessedNvrPredicate, this.maxPreviousBuilds, (FakeKojiXmlRpcApi)this.kojiXmlRpcApi, this.logger);
        } else {
            throw new RuntimeException("Unknown XML-RPC API: " + this.kojiXmlRpcApi.getDescriptor().getDisplayName());
        }
        return buildMatcher.getBuild().orElse(null);
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }
}

