/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm.koji.client;

import hudson.plugins.scm.koji.KojiBuildProvider;
import hudson.plugins.scm.koji.LoggerHelp;
import hudson.plugins.scm.koji.RealKojiXmlRpcApi;
import hudson.plugins.scm.koji.client.BuildMatcher;
import hudson.plugins.scm.koji.client.GlobPredicate;
import hudson.plugins.scm.koji.model.Build;
import hudson.plugins.scm.koji.model.BuildProvider;
import hudson.plugins.scm.koji.model.RPM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import org.fakekoji.xmlrpc.server.xmlrpcrequestparams.GetPackageId;
import org.fakekoji.xmlrpc.server.xmlrpcrequestparams.ListArchives;
import org.fakekoji.xmlrpc.server.xmlrpcrequestparams.ListBuilds;
import org.fakekoji.xmlrpc.server.xmlrpcrequestparams.ListRPMs;
import org.fakekoji.xmlrpc.server.xmlrpcrequestparams.ListTags;
import org.fakekoji.xmlrpc.server.xmlrpcrequestparams.XmlRpcRequestParams;
import org.fakekoji.xmlrpc.server.xmlrpcresponse.ArchiveList;
import org.fakekoji.xmlrpc.server.xmlrpcresponse.BuildList;
import org.fakekoji.xmlrpc.server.xmlrpcresponse.PackageId;
import org.fakekoji.xmlrpc.server.xmlrpcresponse.RPMList;
import org.fakekoji.xmlrpc.server.xmlrpcresponse.TagSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KojiBuildMatcher
extends BuildMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(KojiBuildMatcher.class);
    private final GlobPredicate tagPredicate;
    private final String pkgName;
    private final List<String> archs;

    KojiBuildMatcher(List<KojiBuildProvider> kojiBuildProviders, Predicate<String> notProcessedNvrPredicate, int maxBuilds, RealKojiXmlRpcApi kojiXmlRpcApi, LoggerHelp logger) {
        super(kojiBuildProviders, notProcessedNvrPredicate, maxBuilds, logger);
        this.tagPredicate = new GlobPredicate(kojiXmlRpcApi.getTag(), null);
        this.pkgName = kojiXmlRpcApi.getPackageName();
        this.archs = KojiBuildMatcher.composeArchList(kojiXmlRpcApi.getArch());
    }

    @Override
    List<Build> getBuilds(BuildProvider buildProvider) {
        ArrayList<Build> builds = new ArrayList<Build>();
        for (Build build : this.listPackageBuilds(buildProvider.getTopUrl(), this.pkgName)) {
            Set<String> tags = this.retrieveTags(buildProvider.getTopUrl(), build);
            if (!this.matchesTagPredicate(tags)) continue;
            builds.add(new Build(build.getId(), build.getName(), build.getVersion(), build.getRelease(), build.getNvr(), build.getCompletionTime(), null, tags, buildProvider, null));
        }
        return builds;
    }

    @Override
    Build getBuild(Build build) {
        LOG.debug("Oldest not processed build: " + build.getNvr());
        ArrayList<RPM> rpms = new ArrayList<RPM>();
        rpms.addAll(this.retrieveRPMs(build));
        rpms.addAll(this.retrieveArchives(build));
        return new Build(build.getId(), build.getName(), build.getVersion(), build.getRelease(), build.getNvr(), build.getCompletionTime(), rpms, build.getTags(), build.getProvider(), null);
    }

    private Integer getPackageId(String url, String packageName) {
        GetPackageId params = new GetPackageId(packageName);
        PackageId response = PackageId.create((Object)KojiBuildMatcher.execute(url, (XmlRpcRequestParams)params));
        return response.getValue();
    }

    private List<Build> listPackageBuilds(String url, String packageName) {
        String[] packages = packageName.split("\\s+");
        ArrayList<Build> r = new ArrayList<Build>();
        for (String pkg : packages) {
            r.addAll(this.listPackageBuild(url, pkg));
        }
        return r;
    }

    private List<Build> listPackageBuild(String url, String packageName) {
        Integer packageId = this.getPackageId(url, packageName);
        if (packageId == null) {
            return Collections.emptyList();
        }
        ListBuilds params = new ListBuilds(packageId);
        BuildList response = BuildList.create((Object)KojiBuildMatcher.execute(url, (XmlRpcRequestParams)params));
        List builds = response.getValue();
        if (builds == null || builds.isEmpty()) {
            return Collections.emptyList();
        }
        return builds;
    }

    private Set<String> retrieveTags(String url, Build build) {
        ListTags params = new ListTags(build.getId());
        TagSet response = TagSet.create((Object)KojiBuildMatcher.execute(url, (XmlRpcRequestParams)params));
        return response.getValue();
    }

    private boolean matchesTagPredicate(Set<String> tags) {
        return tags.stream().anyMatch(this.tagPredicate);
    }

    private List<RPM> retrieveRPMs(Build build) {
        ListRPMs params = new ListRPMs(build.getId(), this.archs);
        RPMList response = RPMList.create((Object)KojiBuildMatcher.execute(build.getProvider().getTopUrl(), (XmlRpcRequestParams)params));
        List rpms = response.getValue();
        return rpms == null ? Collections.emptyList() : rpms;
    }

    private List<RPM> retrieveArchives(Build build) {
        ListArchives params = new ListArchives(build.getId(), null);
        ArchiveList response = ArchiveList.create((Object)KojiBuildMatcher.execute(build.getProvider().getTopUrl(), (XmlRpcRequestParams)params));
        List archivefilenames = response.getValue();
        if (archivefilenames == null || archivefilenames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RPM> archives = new ArrayList<RPM>(archivefilenames.size());
        if (KojiBuildMatcher.isBuildContainer(build)) {
            if (this.archs == null || this.archs.isEmpty()) {
                this.addAllContainerArchives(archivefilenames, archives, build);
            } else {
                this.addSelectedArchesContainers(archivefilenames, archives, build);
            }
        } else {
            this.addWindowsArchives(archivefilenames, archives, build);
        }
        return archives;
    }

    private void addWindowsArchives(List<String> archivefilenames, List<RPM> archives, Build build) {
        ArrayList<String> supportedArches = new ArrayList<String>(1);
        supportedArches.add("win");
        for (String archiveName : archivefilenames) {
            for (String arch : this.archs) {
                if (!supportedArches.contains(arch)) continue;
                archives.add(new RPM(build.getName(), build.getVersion(), build.getRelease(), archiveName, arch, archiveName));
            }
        }
    }

    private void addSelectedArchesContainers(List<String> archivefilenames, List<RPM> archives, Build build) {
        for (String archiveName : archivefilenames) {
            for (String arch : this.archs) {
                if (!archiveName.contains("." + arch + ".")) continue;
                archives.add(new RPM(build.getName(), build.getVersion(), build.getRelease(), archiveName, arch, archiveName));
            }
        }
    }

    private void addAllContainerArchives(List<String> archivefilenames, List<RPM> archives, Build build) {
        for (String archiveName : archivefilenames) {
            archives.add(new RPM(build.getName(), build.getVersion(), build.getRelease(), archiveName, this.deductArchFromImage(archiveName), archiveName));
        }
    }

    private static List<String> composeArchList(String arch) {
        if (arch == null || arch.isBlank()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(arch, ",;\n\r\t ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String trimmed = token.trim();
            if (trimmed.isEmpty()) continue;
            list.add(trimmed);
        }
        return list;
    }

    public static boolean isRpmContainer(RPM rpm) {
        return rpm.getName().contains("container") && rpm.getFilename("").contains("docker-image");
    }

    public static boolean isBuildContainer(Build b) {
        return b.getName().contains("container");
    }

    private String deductArchFromImage(String archiveName) {
        return archiveName.replaceAll("\\.tar.*", "").replaceAll(".*\\.", "");
    }
}

