/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm.koji.client;

import com.google.common.io.Files;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.scm.koji.FakeKojiXmlRpcApi;
import hudson.plugins.scm.koji.KojiBuildProvider;
import hudson.plugins.scm.koji.KojiSCM;
import hudson.plugins.scm.koji.KojiXmlRpcApi;
import hudson.plugins.scm.koji.LoggerHelp;
import hudson.plugins.scm.koji.RealKojiXmlRpcApi;
import hudson.plugins.scm.koji.client.BuildMatcher;
import hudson.plugins.scm.koji.client.GlobPredicate;
import hudson.plugins.scm.koji.client.KojiBuildMatcher;
import hudson.plugins.scm.koji.client.KojiListBuilds;
import hudson.plugins.scm.koji.client.TaskListenerLogTransporter;
import hudson.plugins.scm.koji.model.Build;
import hudson.plugins.scm.koji.model.KojiBuildDownloadResult;
import hudson.plugins.scm.koji.model.RPM;
import hudson.remoting.VirtualChannel;
import jakarta.xml.bind.DatatypeConverter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fakekoji.xmlrpc.server.xmlrpcrequestparams.ListArchives;
import org.fakekoji.xmlrpc.server.xmlrpcrequestparams.ListRPMs;
import org.fakekoji.xmlrpc.server.xmlrpcrequestparams.XmlRpcRequestParams;
import org.jenkinsci.remoting.RoleChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.ObjectMapper;

public class KojiBuildDownloader
implements FilePath.FileCallable<KojiBuildDownloadResult>,
LoggerHelp,
TaskListenerLogTransporter {
    private static final Logger LOG = LoggerFactory.getLogger(KojiSCM.class);
    private static final int MAX_REDIRECTIONS = 10;
    private static final int BUFFER_SIZE = 8192;
    private final List<KojiBuildProvider> kojiBuildProviders;
    private final KojiXmlRpcApi kojiXmlRpcApi;
    private final Predicate<String> notProcessedNvrPredicate;
    private TaskListener currentListener;
    private final boolean verbose = true;
    private Build build;
    private final String downloadDir;
    private final int maxPreviousBuilds;
    private final boolean cleanDownloadDir;
    private final boolean dirPerNvr;

    public KojiBuildDownloader(List<KojiBuildProvider> kojiBuildProviders, KojiXmlRpcApi kojiXmlRpcApi, Predicate<String> notProcessedNvrPredicate, Build build, String downloadDir, int maxPreviousBuilds, boolean cleanDownloadDir, boolean dirPerNvr) {
        this.kojiBuildProviders = kojiBuildProviders;
        this.kojiXmlRpcApi = kojiXmlRpcApi;
        this.notProcessedNvrPredicate = notProcessedNvrPredicate;
        this.build = build;
        this.downloadDir = downloadDir;
        this.maxPreviousBuilds = maxPreviousBuilds;
        this.cleanDownloadDir = cleanDownloadDir;
        this.dirPerNvr = dirPerNvr;
    }

    /*
     * WARNING - void declaration
     */
    public KojiBuildDownloadResult invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        if (this.build == null) {
            Build build = new KojiListBuilds(this.kojiBuildProviders, this.kojiXmlRpcApi, this.notProcessedNvrPredicate, this.maxPreviousBuilds, this).invoke(workspace, channel);
            if (build == null) {
                return null;
            }
            this.build = build;
        }
        File targetDir = workspace;
        if (this.downloadDir != null && this.downloadDir.length() > 0) {
            targetDir = new File(targetDir, this.downloadDir);
            if (this.dirPerNvr) {
                targetDir = new File(targetDir, this.build.getNvr());
            }
            if (!targetDir.getAbsoluteFile().equals(workspace.getAbsoluteFile()) && targetDir.exists() && this.cleanDownloadDir) {
                if (!this.build.isManual()) {
                    this.log("cleaning " + targetDir.toString());
                    this.cleanDirRecursively(targetDir);
                } else {
                    this.log("manual tag detected, not cleaning : " + targetDir.toString());
                    String[] l = targetDir.list();
                    if (l == null) {
                        l = new String[]{"Error reading"};
                    }
                    for (String string : l) {
                        this.log("  " + string);
                    }
                }
            } else {
                this.log("NOT cleaning " + targetDir.toString() + ":");
                this.log("" + !targetDir.getAbsoluteFile().equals(workspace.getAbsoluteFile()));
                this.log(String.valueOf(targetDir.getAbsoluteFile()));
                this.log(String.valueOf(workspace.getAbsoluteFile()));
                this.log("" + targetDir.exists());
                this.log("" + this.cleanDownloadDir);
            }
            targetDir.mkdirs();
        }
        if (this.kojiXmlRpcApi instanceof RealKojiXmlRpcApi) {
            RealKojiXmlRpcApi realKojiXmlRpcApi = (RealKojiXmlRpcApi)this.kojiXmlRpcApi;
            List<String> rpmFiles = this.downloadRPMs(targetDir, this.build, realKojiXmlRpcApi);
            File metadataDownloadDir = new File(targetDir.getAbsolutePath() + "-metadata");
            this.downloadMetadata(metadataDownloadDir, this.build);
            this.downloadMetadataFile(metadataDownloadDir, this.kojiBuildProviders, this.build);
            String srcUrl = "";
            for (String suffix : RPM.Suffix.INSTANCE.getSuffixes()) {
                srcUrl = this.composeSrcUrl(this.build.getProvider().getDownloadUrl(), this.build, suffix);
                if (!this.isUrlReachable(srcUrl)) continue;
                this.build.setSrcUrl(new URL(srcUrl));
                break;
            }
            if (this.build.getSrcUrl() == null) {
                URL uRL = new URL(srcUrl);
                try {
                    void var8_13;
                    URI uri;
                    URL uRL2;
                    while (!this.isUrlReachable((uRL2 = (uri = (uri = var8_13.toURI()).getPath().endsWith("/") ? uri.resolve("..") : uri.resolve(".")).toURL()).toString()) && !uRL2.toString().endsWith("..")) {
                    }
                    this.build.setSrcUrl(uRL2);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return new KojiBuildDownloadResult(this.build, targetDir.getAbsolutePath(), rpmFiles);
        }
        if (this.kojiXmlRpcApi instanceof FakeKojiXmlRpcApi) {
            File target = targetDir;
            List<String> rpmPaths = this.build.getRpms().stream().map(rpm -> this.downloadArchive(target, (RPM)rpm)).filter(Optional::isPresent).map(optionalFile -> ((File)optionalFile.get()).getAbsolutePath()).collect(Collectors.toList());
            this.log("Downloaded " + rpmPaths.size() + " out of " + this.build.getRpms().size() + " archives");
            return new KojiBuildDownloadResult(this.build, target.getAbsolutePath(), rpmPaths);
        }
        return null;
    }

    private void downloadMetadataFile(File metadataDownloadDir, List<KojiBuildProvider> kojiBuildProviders, Build build) {
        int i = 0;
        for (KojiBuildProvider provider : kojiBuildProviders) {
            String dwnlodStub = provider.getDownloadUrl();
            String dwnlod = dwnlodStub + "/" + build.getName() + "/" + build.getVersion() + "/" + build.getRelease() + "/metadata.json";
            try {
                InputStream in = new URL(dwnlod).openStream();
                if (in == null) continue;
                ReadableByteChannel readableByteChannel = Channels.newChannel(in);
                FileOutputStream fileOutputStream = new FileOutputStream(metadataDownloadDir.getAbsolutePath() + "/metadata.file." + ++i + ".json");
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            }
            catch (Exception ex) {
                LOG.trace("failed to download " + dwnlod + "; " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private Optional<File> downloadArchive(File targetDir, RPM rpm) {
        if (!this.isUrlReachable(rpm.getUrl())) {
            this.log("URL " + rpm.getUrl() + " not accessible");
            return Optional.empty();
        }
        File targetFile = new File(targetDir, rpm.getFilename(""));
        this.log("Starting downloading " + rpm.getUrl());
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
             InputStream in = this.httpDownloadStream(rpm.getUrl());){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            this.log("Exception while downloading " + rpm.getFilename("") + ": ", (Object)e);
        }
        this.log("Download successful");
        rpm.setHashSum(this.hashSum(targetFile));
        return Optional.of(targetFile);
    }

    private void cleanDirRecursively(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] files = file.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                this.cleanDirRecursively(files[i]);
            }
        }
    }

    private void downloadMetadata(File dir, Build build) {
        this.log("Saving metadata: " + dir.getAbsolutePath());
        if (!dir.exists()) {
            dir.mkdir();
        }
        String METADATA = "metadata";
        ListRPMs rpmParams = new ListRPMs(build.getId(), null);
        Object[] rpms = this.saveMetadata(dir, (XmlRpcRequestParams)rpmParams);
        ListArchives archivesParams = new ListArchives(build.getId(), null);
        Object[] archives = this.saveMetadata(dir, (XmlRpcRequestParams)archivesParams);
        this.metaJsonFile(dir, "metadata").delete();
        if (rpms == null || rpms.length == 0) {
            if (archives != null && archives.length > 0) {
                this.saveMetadata(dir, archives, "metadata");
            }
        } else if ((archives == null || archives.length == 0) && rpms != null && rpms.length > 0) {
            this.saveMetadata(dir, rpms, "metadata");
        }
        try {
            Files.write((CharSequence)build.getName(), (File)new File(dir, "pkgname.txt"), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            this.log("Exception while saving pkgname metadata" + String.valueOf(ex));
        }
        this.saveMetadata(dir, build, "build");
        this.log("Saved metadata: " + Arrays.stream(dir.list()).collect(Collectors.joining(",")));
    }

    private Object[] saveMetadata(File dir, XmlRpcRequestParams params) {
        Object allMetadata = null;
        try {
            allMetadata = BuildMatcher.execute(this.build.getProvider().getTopUrl(), params);
            this.saveMetadata(dir, allMetadata, params.getMethodName());
        }
        catch (Exception ex) {
            this.log("Exception while obtaining " + params.getMethodName() + " metadata" + String.valueOf(ex));
        }
        return (Object[])allMetadata;
    }

    private void saveMetadata(File dir, Object allMetadata, String method) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(allMetadata);
            Files.write((CharSequence)json, (File)this.metaJsonFile(dir, method), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            this.log("Exception while saving " + method + " metadata" + String.valueOf(ex));
        }
    }

    private File metaJsonFile(File dir, String s) {
        return new File(dir, s + ".json");
    }

    public List<String> downloadRPMs(File targetDir, Build build, RealKojiXmlRpcApi realKojiXmlRpcApi) {
        Predicate<RPM> nvrPredicate = i -> true;
        String subpackageDenylist = realKojiXmlRpcApi.getSubpackageDenylist();
        if (subpackageDenylist != null && !subpackageDenylist.isEmpty()) {
            GlobPredicate glob = new GlobPredicate(subpackageDenylist, (TaskListenerLogTransporter)this);
            nvrPredicate = rpm -> {
                if (rpm.getArch().equals("src")) {
                    return true;
                }
                this.log("[KojiSCM] Matching denylist ...");
                return !glob.test((CharSequence)rpm.getNvr());
            };
        }
        Predicate<RPM> allowlistPredicate = i -> true;
        String subpackageAllowlist = realKojiXmlRpcApi.getSubpackageAllowlist();
        if (subpackageAllowlist != null && !subpackageAllowlist.isEmpty()) {
            GlobPredicate glob = new GlobPredicate(subpackageAllowlist, (TaskListenerLogTransporter)this);
            allowlistPredicate = rpm -> {
                if (rpm.getArch().equals("src")) {
                    return true;
                }
                this.log("[KojiSCM] Matching allowlist ...");
                return glob.test((CharSequence)rpm.getNvr());
            };
        }
        List<String> l = build.getRpms().stream().filter(nvrPredicate).filter(allowlistPredicate).map(r -> this.downloadRPM(targetDir, build, (RPM)r)).map(File::getAbsolutePath).collect(Collectors.toList());
        int rpmsInBuildXml = build.getRpms().size();
        int dwnldedFiles = l.size();
        if (dwnldedFiles == 0) {
            if (rpmsInBuildXml == 0) {
                this.log("Warning, nothing downloaded, but looks like  nothing should be.");
            } else {
                this.log("WARNING, nothing downloaded, but should be (" + rpmsInBuildXml + "). Maybe bad exclude packages?");
            }
        }
        return l;
    }

    private File downloadRPM(File targetDir, Build build, RPM rpm) {
        try {
            for (String suffix : RPM.Suffix.INSTANCE.getSuffixes()) {
                String urlString = this.composeUrl(build.getProvider().getDownloadUrl(), build, rpm, suffix);
                this.log(InetAddress.getLocalHost().getHostName());
                this.log(new Date().toString());
                if (build.isManual()) {
                    this.log("Manual tag provided - skipping download of " + urlString);
                } else {
                    this.log("Downloading: " + urlString);
                }
                if (this.isUrlReachable(urlString)) {
                    rpm.setUrl(urlString);
                    File targetFile = new File(targetDir, rpm.getFilename(suffix));
                    this.log("To: " + String.valueOf(targetFile));
                    if (!build.isManual()) {
                        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                             InputStream in = this.httpDownloadStream(urlString);){
                            int read;
                            byte[] buffer = new byte[8192];
                            while ((read = in.read(buffer)) != -1) {
                                ((OutputStream)out).write(buffer, 0, read);
                            }
                        }
                    }
                    rpm.setHashSum(this.hashSum(targetFile));
                    return targetFile;
                }
                this.log("Not accessible, trying another suffix in: " + rpm.getFilename(suffix));
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while downloading RPM", ex);
        }
        return null;
    }

    private String hashSum(File file) {
        MessageDigest hashAlgorithm;
        byte[] buffer = new byte[8192];
        try {
            hashAlgorithm = MessageDigest.getInstance("Md5");
            try (DigestInputStream inputStream = new DigestInputStream(new FileInputStream(file), hashAlgorithm);){
                while (((InputStream)inputStream).read(buffer) > 0) {
                }
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.log("Could not create hash sum of file: " + file.getName(), (Object)e);
            return null;
        }
        return DatatypeConverter.printHexBinary((byte[])hashAlgorithm.digest()).toLowerCase();
    }

    /*
     * Unable to fully structure code
     */
    private InputStream httpDownloadStream(String urlString) {
        httpConn = null;
        keepConnection = false;
        block11: for (i = 0; i < 10; ++i) {
            try {
                url = new URL(urlString);
                httpConn = (HttpURLConnection)url.openConnection();
                httpConn.setRequestMethod("GET");
                response = httpConn.getResponseCode();
                switch (response) {
                    case 200: {
                        keepConnection = true;
                        var7_9 = httpConn.getInputStream();
                        return var7_9;
                    }
                    case 301: 
                    case 302: {
                        location = httpConn.getHeaderField("Location");
                        if (location == null || location.isEmpty()) {
                            throw new Exception("Invalid Location header for response " + response);
                        }
                        if (urlString.equals(location)) {
                            throw new Exception("Infinite redirection loop detected for URL: " + urlString);
                        }
                        urlString = location;
                        ** break;
lbl22:
                        // 1 sources

                        continue block11;
                    }
                    default: {
                        throw new Exception("Unsupported HTTP response " + response + " for URL: " + urlString);
                    }
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (!keepConnection && httpConn != null) {
                    httpConn.disconnect();
                }
            }
        }
        throw new RuntimeException("Too many redirects for URL: " + urlString);
    }

    private String composeUrl(String kojiDownloadUrl, Build build, RPM rpm, String suffix) {
        StringBuilder sb = new StringBuilder(255);
        sb.append(kojiDownloadUrl);
        if (kojiDownloadUrl.charAt(kojiDownloadUrl.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(build.getName()).append('/').append(build.getVersion()).append('/').append(build.getRelease()).append('/').append(KojiBuildDownloader.addArch(rpm)).append('/').append(rpm.getFilename(suffix));
        return sb.toString();
    }

    private String composeSrcUrl(String kojiDownloadUrl, Build build, String suffix) {
        if (kojiDownloadUrl == null || build == null || suffix == null) {
            return "http://unknonw.or/not/found.sorry";
        }
        StringBuilder sb = new StringBuilder(255);
        sb.append(kojiDownloadUrl);
        if (kojiDownloadUrl.charAt(kojiDownloadUrl.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(build.getName()).append('/');
        sb.append(build.getVersion()).append('/');
        sb.append(build.getRelease()).append('/');
        sb.append("src/");
        sb.append(build.getName()).append('-').append(build.getVersion()).append('-').append(build.getRelease()).append(".src.").append(suffix);
        return sb.toString();
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public void setListener(TaskListener listener) {
        this.currentListener = listener;
    }

    private boolean canLog() {
        return this.currentListener != null && this.currentListener.getLogger() != null;
    }

    private String host() {
        try {
            String h = InetAddress.getLocalHost().getHostName();
            if (h == null) {
                return "null";
            }
            return h;
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    void print(String s) {
        try {
            if (this.currentListener != null) {
                this.currentListener.getLogger().println(s);
            }
        }
        catch (Exception ex) {
            LOG.error("During printing of log to TaskListener", (Throwable)ex);
        }
    }

    @Override
    public void log(String s) {
        LOG.debug(s);
        if (this.canLog()) {
            this.print("[KojiSCM][" + this.host() + "] " + s);
        }
    }

    @Override
    public void log(String s, Object o) {
        LOG.debug(s, o);
        if (this.canLog()) {
            this.print("[KojiSCM][" + this.host() + "] " + s + ": " + o.toString());
        }
    }

    @Override
    public void log(String s, Object ... o) {
        LOG.debug(s, o);
        if (this.canLog()) {
            this.print("[KojiSCM][" + this.host() + "] " + s);
            for (Object object : o) {
                this.print("[KojiSCM]   " + object.toString());
            }
        }
    }

    private boolean isUrlReachable(String urlString) {
        try {
            return this.isUrlReachableImpl(urlString, 10);
        }
        catch (Exception e) {
            LOG.debug(e.toString());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUrlReachableImpl(String urlString, int redirectionsRemaining) throws MalformedURLException, IOException {
        URL u = new URL(urlString);
        HttpURLConnection huc = (HttpURLConnection)u.openConnection();
        try {
            huc.setRequestMethod("GET");
            huc.connect();
            int code = huc.getResponseCode();
            if ((code == 301 || code == 302) && redirectionsRemaining > 0) {
                boolean bl = this.isUrlReachableImpl(huc.getHeaderField("Location"), redirectionsRemaining - 1);
                return bl;
            }
            boolean bl = code == 200;
            return bl;
        }
        finally {
            huc.disconnect();
        }
    }

    private static String addArch(RPM rpm) {
        if (KojiBuildMatcher.isRpmContainer(rpm)) {
            return "images";
        }
        return rpm.getArch();
    }

    public void println(String s) {
        if (this.currentListener != null) {
            this.currentListener.getLogger().println(s);
        }
    }
}

