/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm.koji.client;

import hudson.plugins.scm.koji.Constants;
import hudson.plugins.scm.koji.KojiBuildProvider;
import hudson.plugins.scm.koji.KojiSCM;
import hudson.plugins.scm.koji.LoggerHelp;
import hudson.plugins.scm.koji.client.tools.XmlRpcHelper;
import hudson.plugins.scm.koji.model.Build;
import hudson.plugins.scm.koji.model.BuildProvider;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fakekoji.xmlrpc.server.expensiveobjectscache.RemoteRequestCacheConfigKeys;
import org.fakekoji.xmlrpc.server.expensiveobjectscache.RemoteRequestsCache;
import org.fakekoji.xmlrpc.server.xmlrpcrequestparams.XmlRpcRequestParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BuildMatcher {
    private static final OrderBy orderBy = OrderBy.DATE;
    private final List<KojiBuildProvider> buildProviders;
    private final Predicate<String> notProcessedNvrPredicate;
    private final int maxBuilds;
    private final LoggerHelp logger;
    private static final Logger LOG = LoggerFactory.getLogger(KojiSCM.class);
    private static final RemoteRequestsCache cache = new RemoteRequestsCache(RemoteRequestCacheConfigKeys.DEFAULT_CONFIG_LOCATION, (url, params) -> new XmlRpcHelper.XmlRpcExecutioner(url).execute(params));

    BuildMatcher(List<KojiBuildProvider> buildProviders, Predicate<String> notProcessedNvrPredicate, int maxBuilds, LoggerHelp logger) {
        this.buildProviders = buildProviders;
        this.notProcessedNvrPredicate = notProcessedNvrPredicate;
        this.maxBuilds = maxBuilds;
        this.logger = logger;
    }

    public static Stream<Build> listBuilds(BuildMatcher bm, LoggerHelp logger) {
        for (KojiBuildProvider provider : bm.buildProviders) {
            try {
                List<Build> builds = bm.getBuilds(provider.getBuildProvider());
                if (builds.isEmpty()) {
                    throw new RuntimeException("No builds found.");
                }
                List filteredBuilds = builds.stream().sorted(BuildMatcher::compare).limit(bm.maxBuilds).filter(build -> bm.notProcessedNvrPredicate.test(build.getNvr())).collect(Collectors.toList());
                if (filteredBuilds.isEmpty()) {
                    throw new RuntimeException("No filteredBuilds found.");
                }
                return filteredBuilds.stream();
            }
            catch (Exception ex) {
                if (logger != null) {
                    logger.log("", (Object)ex);
                    logger.log("Failed to read builds from " + provider.getTopUrl() + ", trying next one");
                }
                LOG.warn("", (Throwable)ex);
                LOG.error("Failed to read builds from " + provider.getTopUrl() + ", trying next one");
            }
        }
        throw new RuntimeException("All providers tried, all failed");
    }

    public static Optional<Build> getLatestOfNewestBuilds(BuildMatcher bm, LoggerHelp logger) {
        Optional<Build> buildOptional = BuildMatcher.listBuilds(bm, logger).max(BuildMatcher::compare);
        return buildOptional.map(bm::getBuild);
    }

    public Optional<Build> getBuild() {
        return BuildMatcher.getLatestOfNewestBuilds(this, this.logger);
    }

    abstract List<Build> getBuilds(BuildProvider var1);

    abstract Build getBuild(Build var1);

    public static int compare(Build b1, Build b2) {
        switch (orderBy.ordinal()) {
            case 0: {
                return BuildMatcher.compareBuildsByCompletionTime(b1, b2);
            }
            case 1: {
                return BuildMatcher.compareBuildVersions(b1, b2);
            }
        }
        throw new RuntimeException("Unknown order");
    }

    public static Object execute(String url, XmlRpcRequestParams params) {
        return cache.obtain(url, params);
    }

    public static int compareBuildsByCompletionTime(Build b1, Build b2) {
        return BuildMatcher.compareKojiTime(b1.getCompletionTime(), b2.getCompletionTime(), Constants.DTF);
    }

    private static int compareKojiTime(String s1, String s2, DateTimeFormatter d) {
        LocalDateTime thisCompletionTime = LocalDateTime.parse(BuildMatcher.sanitizeBadKojiDate(s1), d);
        LocalDateTime thatCompletionTime = LocalDateTime.parse(BuildMatcher.sanitizeBadKojiDate(s2), d);
        return thatCompletionTime.compareTo(thisCompletionTime);
    }

    static String sanitizeBadKojiDate(String corruptedDate) {
        if (corruptedDate.contains("+")) {
            return corruptedDate.replaceAll("\\+[0-9]{1,2}:[0-9]{1,2}$", "");
        }
        return corruptedDate;
    }

    private static int compareBuildVersions(Build b1, Build b2) {
        int res = BuildMatcher.compareStrings(b1.getVersion(), b2.getVersion());
        if (res != 0) {
            return res;
        }
        return BuildMatcher.compareStrings(b1.getRelease(), b2.getRelease());
    }

    private static int compareStrings(String s1, String s2) {
        StringTokenizer tokenizer1 = new StringTokenizer(s1, "-.");
        StringTokenizer tokenizer2 = new StringTokenizer(s2, "-.");
        while (tokenizer1.hasMoreTokens() && tokenizer2.hasMoreTokens()) {
            String t1 = tokenizer1.nextToken();
            String t2 = tokenizer2.nextToken();
            if (BuildMatcher.allDigits(t1) && BuildMatcher.allDigits(t2)) {
                int i2;
                int i1 = Integer.parseInt(t1);
                int intCompared = i1 - (i2 = Integer.parseInt(t2));
                if (intCompared == 0) continue;
                return intCompared > 0 ? -1 : 1;
            }
            int stringCompared = t1.compareTo(t2);
            if (stringCompared == 0) continue;
            return stringCompared > 0 ? -1 : 1;
        }
        if (tokenizer1.hasMoreTokens()) {
            return -1;
        }
        if (tokenizer2.hasMoreTokens()) {
            return 1;
        }
        return 0;
    }

    private static boolean allDigits(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static enum OrderBy {
        DATE,
        VERSION;

    }
}

