/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm.koji;

import hudson.DescriptorExtensionList;
import hudson.model.Descriptor;
import hudson.plugins.scm.koji.KojiRepositoryBrowser;
import hudson.plugins.scm.koji.KojiSCM;
import hudson.plugins.scm.koji.KojiXmlRpcApi;
import hudson.scm.SCMDescriptor;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KojiScmDescriptor
extends SCMDescriptor<KojiSCM> {
    private static final Logger LOG = LoggerFactory.getLogger(SCMDescriptor.class);
    private boolean KojiSCMConfig_requireWorkspace = true;
    private boolean KojiSCMConfig_skipPoolingIfJobRuns = false;

    public KojiScmDescriptor() {
        super(KojiSCM.class, KojiRepositoryBrowser.class);
        try {
            this.load();
        }
        catch (Exception ex) {
            LOG.error(ex.toString());
            ex.printStackTrace();
        }
    }

    public DescriptorExtensionList<KojiXmlRpcApi, KojiXmlRpcApi.KojiXmlRpcApiDescriptor> getKojiXmlRpcApiDescriptorList() {
        return Jenkins.get().getDescriptorList(KojiXmlRpcApi.class);
    }

    public String getDisplayName() {
        return "Koji";
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        this.KojiSCMConfig_requireWorkspace = json.getBoolean("KojiSCMConfig_requireWorkspace");
        this.KojiSCMConfig_skipPoolingIfJobRuns = json.getBoolean("KojiSCMConfig_skipPoolingIfJobRuns");
        LOG.debug("KojiSCMConfig_requireWorkspace configured to: " + this.KojiSCMConfig_requireWorkspace);
        LOG.debug("KojiSCMConfig_skipPoolingIfJobRuns configured to: " + this.KojiSCMConfig_skipPoolingIfJobRuns);
        this.save();
        return true;
    }

    public boolean getKojiSCMConfig_requireWorkspace() {
        LOG.debug("KojiSCMConfig_requireWorkspace returning " + this.KojiSCMConfig_requireWorkspace);
        return this.KojiSCMConfig_requireWorkspace;
    }

    public boolean getKojiSCMConfig_skipPoolingIfJobRuns() {
        LOG.debug("KojiSCMConfig_skipPoolingIfJobRuns returning " + this.KojiSCMConfig_skipPoolingIfJobRuns);
        return this.KojiSCMConfig_skipPoolingIfJobRuns;
    }

    @DataBoundSetter
    public void setKojiSCMConfig_requireWorkspace(boolean kojiSCMConfig) {
        LOG.debug("KojiSCMConfig_requireWorkspace set from" + this.KojiSCMConfig_requireWorkspace + " to " + kojiSCMConfig);
        this.KojiSCMConfig_requireWorkspace = kojiSCMConfig;
    }

    @DataBoundSetter
    public void setKojiSCMConfig_skipPoolingIfJobRuns(boolean kojiSCMConfig) {
        LOG.debug("KojiSCMConfig_skipPoolingIfJobRuns set from" + this.KojiSCMConfig_skipPoolingIfJobRuns + " to " + kojiSCMConfig);
        this.KojiSCMConfig_skipPoolingIfJobRuns = kojiSCMConfig;
    }
}

