/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm.koji;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.scm.koji.BuildsSerializer;
import hudson.plugins.scm.koji.KojiBuildProvider;
import hudson.plugins.scm.koji.KojiChangeLogParser;
import hudson.plugins.scm.koji.KojiEnvVarsAction;
import hudson.plugins.scm.koji.KojiRevisionFromBuild;
import hudson.plugins.scm.koji.KojiRevisionState;
import hudson.plugins.scm.koji.KojiScmDescriptor;
import hudson.plugins.scm.koji.KojiXmlRpcApi;
import hudson.plugins.scm.koji.LoggerHelp;
import hudson.plugins.scm.koji.NotProcessedNvrPredicate;
import hudson.plugins.scm.koji.client.KojiBuildDownloader;
import hudson.plugins.scm.koji.client.KojiListBuilds;
import hudson.plugins.scm.koji.model.Build;
import hudson.plugins.scm.koji.model.KojiBuildDownloadResult;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KojiSCM
extends SCM
implements LoggerHelp,
Serializable {
    @Extension
    public static final KojiScmDescriptor DESCRIPTOR = new KojiScmDescriptor();
    private static final Logger LOG = LoggerFactory.getLogger(KojiSCM.class);
    private static final boolean verbose = true;
    private final Collection<KojiBuildProvider> kojiBuildProviders;
    private final KojiXmlRpcApi kojiXmlRpcApi;
    private String downloadDir;
    private boolean cleanDownloadDir;
    private boolean dirPerNvr;
    private int maxPreviousBuilds;
    private transient TaskListener currentListener;
    private static final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss_XXX");

    private boolean canLog() {
        return this.currentListener != null && this.currentListener.getLogger() != null;
    }

    private String host() {
        try {
            String h = InetAddress.getLocalHost().getHostName();
            if (h == null) {
                return "null";
            }
            return h;
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    void print(String s) {
        try {
            if (this.currentListener != null) {
                this.currentListener.getLogger().println(s);
            }
        }
        catch (Exception ex) {
            LOG.error("During printing of log to TaskListener", (Throwable)ex);
        }
    }

    @Override
    public void log(String s) {
        LOG.debug(s);
        if (this.canLog()) {
            this.print("[KojiSCM][" + this.host() + "] " + s);
        }
    }

    @Override
    public void log(String s, Object o) {
        LOG.debug(s, o);
        if (this.canLog()) {
            if (o == null) {
                o = "null";
            }
            this.print("[KojiSCM][" + this.host() + "] " + s + ": " + o.toString());
        }
    }

    @Override
    public void log(String s, Object ... o) {
        LOG.debug(s, o);
        if (this.canLog()) {
            this.print("[KojiSCM][" + this.host() + "] " + s);
            for (Object object : o) {
                if (object == null) {
                    object = "null";
                }
                this.print("[KojiSCM]   " + object.toString());
            }
        }
    }

    @DataBoundConstructor
    public KojiSCM(Collection<KojiBuildProvider> kojiBuildProviders, KojiXmlRpcApi kojiXmlRpcApi, String downloadDir, boolean cleanDownloadDir, boolean dirPerNvr, int maxPreviousBuilds) {
        this.kojiBuildProviders = kojiBuildProviders;
        this.kojiXmlRpcApi = kojiXmlRpcApi;
        this.downloadDir = downloadDir;
        this.cleanDownloadDir = cleanDownloadDir;
        this.dirPerNvr = dirPerNvr;
        this.maxPreviousBuilds = maxPreviousBuilds;
    }

    public ChangeLogParser createChangeLogParser() {
        return new KojiChangeLogParser();
    }

    public SCMDescriptor<?> getDescriptor() {
        return DESCRIPTOR;
    }

    public static <T> List<T> iterableToList(Iterable<T> iterable) {
        ArrayList list = new ArrayList();
        iterable.forEach(list::add);
        return list;
    }

    public void checkout(Run<?, ?> run, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        this.currentListener = listener;
        this.log("{}", (Object)this);
        this.log("Checking out remote revision");
        if (baseline != null && !(baseline instanceof KojiRevisionState)) {
            throw new RuntimeException("Expected instance of KojiRevisionState, got: " + String.valueOf(baseline));
        }
        File checkoutBuildFile = new File(run.getParent().getRootDir(), "build.xml");
        Build storedBuild = new BuildsSerializer().read(checkoutBuildFile);
        KojiBuildDownloader downloadWorker = new KojiBuildDownloader(KojiSCM.iterableToList(this.kojiBuildProviders), this.kojiXmlRpcApi, this.createNotProcessedNvrPredicate(run.getParent()), storedBuild, this.downloadDir, this.maxPreviousBuilds, this.cleanDownloadDir, this.dirPerNvr);
        downloadWorker.setListener(listener);
        KojiBuildDownloadResult downloadResult = (KojiBuildDownloadResult)workspace.act((FilePath.FileCallable)downloadWorker);
        if (downloadResult == null) {
            this.log("Checkout finished without any results");
            listener.getLogger().println("No updates.");
            throw new AbortException("Checkout was invoked but no remote changes found");
        }
        Build build = downloadResult.getBuild();
        this.log("Checkout downloaded build: {}", (Object)build);
        if (storedBuild == null) {
            this.storeBuild(build, run.getParent().getRootDir());
        }
        String displayName = build.getVersion() + "-" + build.getRelease();
        this.log("Updating the build name to: {}", (Object)displayName);
        if (build.isManual()) {
            run.setDisplayName(displayName + "(manual)");
        } else {
            run.setDisplayName(displayName);
        }
        if (build.isManual()) {
            this.log("manual mode -  not saving the nvr of checked out build to history: {} >> {}", build.getNvr(), "processed.txt");
        } else {
            this.log("Saving the nvr of checked out build to history: {} >> {}", build.getNvr(), "processed.txt");
            KojiSCM.appendBuildNvrToProcessed(new File(run.getParent().getRootDir(), "processed.txt"), build);
        }
        if (changelogFile != null) {
            this.log("Saving the build info to changelog file: {}", (Object)changelogFile.getAbsolutePath());
            new BuildsSerializer().write(build, changelogFile);
        }
        run.addAction((Action)new KojiEnvVarsAction(build.getNvr(), downloadResult.getRpmsDirectory(), String.join((CharSequence)File.pathSeparator, downloadResult.getRpmFiles())));
    }

    static void appendBuildNvrToProcessed(File processed, Build build) throws IOException {
        KojiSCM.appendStringProcessed(processed, build.getNvr() + "  # " + formatter.format(new Date()));
    }

    static void appendStringProcessed(File processed, String nvr) throws IOException {
        Files.write(processed.toPath(), Collections.singletonList(nvr), StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }

    private void storeBuild(Build build, File dir) {
        File file = new File(dir, "build.xml");
        this.log("Saving " + String.valueOf(build) + " to " + file.getAbsolutePath());
        new BuildsSerializer().write(build, file);
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        Build build;
        this.currentListener = listener;
        this.log("Comparing remote revision with: " + String.valueOf(baseline));
        if (!(baseline instanceof KojiRevisionState)) {
            throw new RuntimeException("Expected instance of KojiRevisionState, got: " + String.valueOf(baseline));
        }
        KojiListBuilds worker = new KojiListBuilds(KojiSCM.iterableToList(this.kojiBuildProviders), this.kojiXmlRpcApi, this.createNotProcessedNvrPredicate(project), this.maxPreviousBuilds, this);
        if (!DESCRIPTOR.getKojiSCMConfig_requireWorkspace()) {
            if (this.skipBuildingIfDesired(project)) {
                build = null;
                this.log("Skipping pooling because the job is running.");
            } else {
                File wFile = null;
                if (workspace != null) {
                    wFile = new File(workspace.toURI().getPath());
                }
                build = worker.invoke(wFile, null);
            }
        } else if (this.skipBuildingIfDesired(project)) {
            build = null;
            this.log("Skipping pooling because the job is running. You have both `require workspace` and `skip poling on running', that is nonsense");
        } else {
            build = (Build)workspace.act((FilePath.FileCallable)worker);
        }
        if (build != null) {
            this.log("Got new remote build: " + String.valueOf(build));
            this.storeBuild(build, project.getRootDir());
            return new PollingResult(baseline, (SCMRevisionState)new KojiRevisionState(build), PollingResult.Change.INCOMPARABLE);
        }
        this.log("No remote changes");
        return new PollingResult(baseline, null, PollingResult.Change.NONE);
    }

    private boolean skipBuildingIfDesired(Job<?, ?> project) {
        if (DESCRIPTOR.getKojiSCMConfig_skipPoolingIfJobRuns()) {
            return project.isBuilding();
        }
        return false;
    }

    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        this.currentListener = listener;
        this.log("Calculating revision for project '{}' from build: {}", run.getParent().getName(), run.getNumber());
        KojiRevisionFromBuild worker = new KojiRevisionFromBuild();
        FilePath buildWorkspace = new FilePath(run.getRootDir());
        Build build = (Build)buildWorkspace.act((FilePath.FileCallable)worker);
        if (build != null) {
            this.log("Got revision from build {}: {}", run.getNumber(), build.getNvr());
            return new KojiRevisionState(build);
        }
        this.log("No build info found");
        return new KojiRevisionState(null);
    }

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return DESCRIPTOR.getKojiSCMConfig_requireWorkspace();
    }

    private Predicate<String> createNotProcessedNvrPredicate(Job<?, ?> job) throws IOException {
        File processedNvrFile = new File(job.getRootDir(), "processed.txt");
        File globalProcessedNvrFile = new File(job.getRootDir().getParentFile(), "processed.txt");
        return NotProcessedNvrPredicate.createNotProcessedNvrPredicateFromFile((File)processedNvrFile, (File)globalProcessedNvrFile);
    }

    public Collection<KojiBuildProvider> getKojiBuildProviders() {
        return this.kojiBuildProviders;
    }

    public KojiXmlRpcApi getKojiXmlRpcApi() {
        return this.kojiXmlRpcApi;
    }

    public String getDownloadDir() {
        return this.downloadDir;
    }

    @DataBoundSetter
    public void setDownloadDir(String downloadDir) {
        this.downloadDir = downloadDir;
    }

    public boolean isCleanDownloadDir() {
        return this.cleanDownloadDir;
    }

    @DataBoundSetter
    public void setCleanDownloadDir(boolean cleanDownloadDir) {
        this.cleanDownloadDir = cleanDownloadDir;
    }

    public boolean isDirPerNvr() {
        return this.dirPerNvr;
    }

    @DataBoundSetter
    public void setDirPerNvr(boolean dirPerNvr) {
        this.dirPerNvr = dirPerNvr;
    }

    public int getMaxPreviousBuilds() {
        return this.maxPreviousBuilds;
    }

    @DataBoundSetter
    public void setMaxPreviousBuilds(int maxPreviousBuilds) {
        this.maxPreviousBuilds = maxPreviousBuilds;
    }

    public String toString() {
        return "Koji SCM: \n\nBuild Providers:\n" + this.kojiBuildProviders.stream().map(KojiBuildProvider::toString).collect(Collectors.joining("----------\n")) + "\n" + String.valueOf(this.kojiXmlRpcApi) + "\ndownloadDir: " + this.downloadDir + "\ncleanDownloadDir: " + this.cleanDownloadDir + "\ndirPerNvr: " + this.dirPerNvr + "\nmaxPreviousBuilds: " + this.maxPreviousBuilds + "\n";
    }
}

