/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm.koji;

import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.scm.koji.model.Build;
import hudson.plugins.scm.koji.model.RPM;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import hudson.security.Permission;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;

public class KojiChangeLogSet
extends ChangeLogSet<ChangeLogSet.Entry> {
    public static final String OTOOL_ACTIONS = "Otool Actions";
    private final Build build;
    private final List<ChangeLogSet.Entry> entries;
    private static final String OTOOL_URL = "OTOOL_URL_JENKINS_SMC_KOJI_PLUGIN";

    public KojiChangeLogSet(Build build, Run<?, ?> run, RepositoryBrowser<?> browser) {
        super(run, browser);
        this.build = build;
        if (build != null) {
            List<ChangeLogSet.Entry> list = Arrays.asList(new ChangeLogSet.Entry[]{new KojiChangeEntry("Build Name", Collections.singletonList(new Hyperlink(build.getName()))), new KojiChangeEntry("Build Version", Collections.singletonList(new Hyperlink(build.getVersion()))), new KojiChangeEntry("Build Release", Collections.singletonList(new Hyperlink(build.getRelease()))), new KojiChangeEntry("Build NVR", Collections.singletonList(new Hyperlink(build.getNvr()))), new KojiChangeEntry("Build Tags", Collections.singletonList(new Hyperlink(String.join((CharSequence)", ", build.getTags())))), new KojiChangeEntry("Build RPMs/Tarballs", KojiChangeLogSet.getListFromRPMs(build.getRpms())), new KojiChangeEntry("Build Sources", KojiChangeLogSet.getListFromUrl(build.getSrcUrl())), new KojiChangeEntry(OTOOL_ACTIONS, this.getActions())});
            this.entries = Collections.unmodifiableList(list);
        } else {
            this.entries = Collections.emptyList();
        }
    }

    public boolean isEmptySet() {
        return false;
    }

    public Iterator<ChangeLogSet.Entry> iterator() {
        return this.entries.iterator();
    }

    private String nvr1() {
        return this.build.getNvr();
    }

    private String nvr2() {
        return this.build.getName() + "-" + this.build.getVersion() + "-" + this.build.getRelease();
    }

    private List<Hyperlink> getActions() {
        ArrayList<Hyperlink> r = new ArrayList<Hyperlink>();
        r.add(new Hyperlink("                           "));
        r.add(new Hyperlink("           help            ", this.misc() + "/help"));
        r.add(new Hyperlink("                           "));
        r.add(this.checkoutNvr(this.nvr1()));
        if (this.haveDualNvr()) {
            r.add(this.checkoutNvr(this.nvr2()));
        }
        r.add(new Hyperlink("re/run", this.prefix("run?do=true&job=" + this.getJobName() + "&build=" + this.getRun().getId()), "copy " + this.getRun().getId() + "/changelog.xml as build.xml and Build Now"));
        r.add(this.testNvr(this.nvr1()));
        if (this.haveDualNvr()) {
            r.add(this.testNvr(this.nvr2()));
        }
        r.add(new Hyperlink("re/checkout", this.prefix("checkout?&job=" + this.getJobName() + "&do=true"), "remove build.xml and Build Now. If all builds are in processed.txt, will evolve to fail"));
        r.add(new Hyperlink("re/processed", this.prefix("processed?job=" + this.getJobName()), "show processed.txt"));
        r.add(new Hyperlink("re/load", this.prefix("load?job=" + this.getJobName()), "simply relaod the job"));
        return r;
    }

    private String prefix(String s) {
        return this.misc() + "/re/" + s;
    }

    private String misc() {
        return this.getOtoolUrl() + "/misc";
    }

    private String getJobName() {
        return this.getRun().getFullDisplayName().split("\\s+")[0];
    }

    private boolean haveDualNvr() {
        return !this.nvr1().equals(this.nvr2());
    }

    private Hyperlink testNvr(String nvr) {
        if (this.getJobName().startsWith("build-")) {
            return new Hyperlink("re/build?nvr=", this.prefix("build?nvr=" + nvr + "&allowlist=" + this.getJobName() + "&do=true"), "remove " + nvr + " from processed.txt Build Now");
        }
        return new Hyperlink("re/test?nvr=", this.prefix("test?nvr=" + nvr + "&allowlist=" + this.getJobName() + "&do=true"), "remove " + nvr + " from processed.txt Build Now");
    }

    private Hyperlink checkoutNvr(String nvr) {
        return new Hyperlink("re/checkout?nvr=", this.prefix("checkout?job=" + this.getJobName() + "&do=true&nvr=" + nvr), "remove build.xml, remove " + nvr + " from processed.txt Build Now");
    }

    public String getOtoolUrl() {
        try {
            if (System.getenv(OTOOL_URL) != null) {
                return System.getenv(OTOOL_URL);
            }
            InetAddress inetAddress = InetAddress.getLocalHost();
            return "http://" + inetAddress.getHostName() + ":8888";
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Hyperlink> getListFromRPMs(List<RPM> rpms) {
        Predicate<RPM> predicate = KojiChangeLogSet.atLeastOneRPMHasUrl(rpms) ? rpm -> rpm.getUrl() != null : rpm -> true;
        return rpms.stream().filter(predicate).map(rpm -> new Hyperlink(rpm.toString(), rpm.getUrl(), rpm.getHashSum())).collect(Collectors.toList());
    }

    private static List<Hyperlink> getListFromUrl(URL url) {
        ArrayList<Hyperlink> hyperlinks = new ArrayList<Hyperlink>();
        if (url != null) {
            if (RPM.Suffix.INSTANCE.endsWithSuffix(url.toString())) {
                hyperlinks.add(new Hyperlink(new File(url.getPath()).getName(), url.toString()));
            } else {
                hyperlinks.add(new Hyperlink("Source file not found. You can search for it here.", url.toString()));
            }
        }
        return hyperlinks;
    }

    private static boolean atLeastOneRPMHasUrl(List<RPM> rpms) {
        for (RPM rpm : rpms) {
            if (rpm.getUrl() == null) continue;
            return true;
        }
        return false;
    }

    public static class KojiChangeEntry
    extends ChangeLogSet.Entry {
        private final String field;
        private final List<Hyperlink> hyperlinks;

        public KojiChangeEntry(String field, List<Hyperlink> hyperlinks) {
            this.field = field;
            this.hyperlinks = hyperlinks;
        }

        public boolean canShow() {
            if (KojiChangeLogSet.OTOOL_ACTIONS.equals(this.field)) {
                return Jenkins.get().hasPermission(Permission.WRITE) || Jenkins.get().hasPermission(Permission.CREATE) || Jenkins.get().hasPermission(Permission.CONFIGURE) || Jenkins.get().hasPermission(Permission.DELETE);
            }
            return true;
        }

        public String getField() {
            return this.field;
        }

        public List<Hyperlink> getHyperlinks() {
            return this.hyperlinks;
        }

        public String getMsg() {
            return this.field + ": " + this.hyperlinks.toString();
        }

        public User getAuthor() {
            return User.current();
        }

        public Collection<String> getAffectedPaths() {
            return Collections.emptyList();
        }
    }

    public static class Hyperlink {
        private final String displayedString;
        private final String url;
        private final String hashSum;

        Hyperlink(String displayedString) {
            this.displayedString = displayedString;
            this.url = null;
            this.hashSum = null;
        }

        Hyperlink(String displayedString, String url) {
            this.displayedString = displayedString;
            this.url = url;
            this.hashSum = null;
        }

        Hyperlink(String displayedString, String url, String hashSum) {
            this.displayedString = displayedString;
            this.url = url;
            this.hashSum = hashSum;
        }

        public String getDisplayedString() {
            return this.displayedString;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isContainingUrl() {
            return this.url != null;
        }

        public boolean isContainingHashSum() {
            return this.hashSum != null;
        }

        public String getHashSum() {
            return this.hashSum;
        }

        public String showSum() {
            if (this.hashSum.contains(" ")) {
                return this.hashSum;
            }
            return "MD5: " + this.hashSum;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Hyperlink{");
            sb.append("displayedString='").append(this.displayedString).append('\'');
            sb.append(", url='").append(this.url).append('\'');
            sb.append(", hashSum='").append(this.hashSum).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

