/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm.koji;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.plugins.scm.koji.model.BuildProvider;
import hudson.util.FormValidation;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class KojiBuildProvider
implements Describable<KojiBuildProvider>,
Serializable {
    private final BuildProvider buildProvider;

    @DataBoundConstructor
    public KojiBuildProvider(String topUrl, String downloadUrl) {
        this.buildProvider = new BuildProvider(topUrl, downloadUrl);
    }

    public Descriptor<KojiBuildProvider> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    public BuildProvider getBuildProvider() {
        return this.buildProvider;
    }

    public String getTopUrl() {
        return this.buildProvider.getTopUrl();
    }

    public String getDownloadUrl() {
        return this.buildProvider.getDownloadUrl();
    }

    public String toString() {
        return "topUrl: " + this.getTopUrl() + "\ndownloadUrl: " + this.getDownloadUrl() + "\n";
    }

    @Extension
    public static final class KojiBuildProviderDescriptor
    extends Descriptor<KojiBuildProvider> {
        private static final String SUPPORTED_PROTOCOL = "HTTP";
        private static final String URL_INVALID = "The URL is invalid";
        private static final String PROTOCOL_NOT_SUPPORTED = "Only HTTP protocol is supported";

        @NonNull
        public String getDisplayName() {
            return "Koji build provider";
        }

        public FormValidation doCheckTopUrl(@QueryParameter String value) {
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)URL_INVALID);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDownloadUrl(@QueryParameter String value) {
            try {
                URL url = new URL(value);
                if (!url.getProtocol().equals(SUPPORTED_PROTOCOL.toLowerCase())) {
                    return FormValidation.error((String)PROTOCOL_NOT_SUPPORTED);
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)URL_INVALID);
            }
            return FormValidation.ok();
        }
    }
}

