/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.scm.koji;

import hudson.plugins.scm.koji.model.Build;
import hudson.plugins.scm.koji.model.RPM;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;

public class BuildsSerializer {
    private static SoftReference<JAXBContext> JAXB_CONTEXT_REFERENCE = new SoftReference<Object>(null);

    private static JAXBContext jaxbContext() {
        try {
            JAXBContext context = JAXB_CONTEXT_REFERENCE.get();
            if (context == null) {
                context = JAXBContext.newInstance((Class[])new Class[]{Build.class, RPM.class});
                JAXB_CONTEXT_REFERENCE = new SoftReference<JAXBContext>(context);
            }
            return context;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while initializing JAXB context", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Build read(File file) {
        if (!file.exists()) return null;
        if (!file.isFile()) return null;
        if (file.length() < 1L) {
            return null;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), "UTF-8");){
            Object result = BuildsSerializer.jaxbContext().createUnmarshaller().unmarshal((Reader)reader);
            if (result != null) {
                if (!(result instanceof Build)) throw new RuntimeException("Deserialization expected Build but got: " + String.valueOf(result));
            }
            Build build = (Build)result;
            return build;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while reading the build XML", ex);
        }
    }

    public void write(Build build, File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8");){
            Marshaller marshaller = BuildsSerializer.jaxbContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)build, (Writer)writer);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while writing the build to file", ex);
        }
    }
}

