/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.sync;

import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.View;
import hudson.security.AccessControlled;
import hudson.util.FormApply;
import hudson.util.QuotedStringTokenizer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.marvelution.jji.Messages;
import org.marvelution.jji.SitesClient;
import org.marvelution.jji.configuration.JiraSite;

public abstract class JiraSyncAction<S extends Saveable & AccessControlled>
implements Action {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final SitesClient sitesClient;
    protected final S target;

    protected JiraSyncAction(SitesClient sitesClient, S target) {
        this.target = target;
        this.sitesClient = sitesClient;
    }

    public String getIconFileName() {
        return "/plugin/jira-integration/images/48x48/jji.png";
    }

    public String getDisplayName() {
        return Messages.jira_sync();
    }

    public String getUrlName() {
        return "syncWithJira";
    }

    public S getTarget() {
        return this.target;
    }

    public abstract String getTargetDisplayName();

    public Set<JiraSite> getSites() {
        return this.sitesClient.getSites();
    }

    @RequirePOST
    public synchronized void doSubmit(StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        ((AccessControlled)this.target).getACL().checkPermission(Item.CONFIGURE);
        try {
            HashSet<String> selectedSites = new HashSet<String>();
            JSONObject form = request.getSubmittedForm();
            Object jsonSite = form.get("site");
            if (jsonSite instanceof String) {
                selectedSites.add((String)jsonSite);
            } else if (jsonSite instanceof JSONArray) {
                selectedSites.addAll(((JSONArray)jsonSite).stream().map(Object::toString).collect(Collectors.toList()));
            }
            if (selectedSites.isEmpty()) {
                this.generateResponse(request, response, Messages.no_sites_selected(), "WARNING");
            } else {
                this.sync(site -> selectedSites.contains(site.getIdentifier()));
                this.generateResponse(request, response, Messages.triggered_sync_of(this.getTargetDisplayName()), "OK");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to synchronize " + this.getTargetDisplayName() + " with Jira; " + e.getMessage(), e);
            this.generateResponse(request, response, Messages.unable_to_trigger_sync_of(this.getTargetDisplayName()), "ERROR");
        }
    }

    private void generateResponse(StaplerRequest request, StaplerResponse response, String message, String type) throws IOException, ServletException {
        FormApply.applyResponse((String)("notificationBar.show(" + QuotedStringTokenizer.quote((String)message) + ",notificationBar." + type + ")")).generateResponse(request, response, (Object)this);
    }

    protected abstract void sync(Predicate<JiraSite> var1);

    public static class ViewJiraSyncAction
    extends JiraSyncAction<View> {
        public ViewJiraSyncAction(SitesClient sitesClient, View view) {
            super(sitesClient, view);
        }

        @Override
        public String getTargetDisplayName() {
            return ((View)this.target).getViewName() + " of " + ((View)this.target).getOwner().getDisplayName();
        }

        @Override
        protected void sync(Predicate<JiraSite> siteFilter) {
            ((View)this.target).getAllItems().forEach(item -> this.sitesClient.syncJob(siteFilter, (Item)item));
        }
    }

    public static class BuildJiraSyncAction
    extends JiraSyncAction<Run> {
        public BuildJiraSyncAction(SitesClient sitesClient, Run target) {
            super(sitesClient, target);
        }

        @Override
        public String getTargetDisplayName() {
            return ((Run)this.target).getFullDisplayName();
        }

        @Override
        protected void sync(Predicate<JiraSite> siteFilter) {
            this.sitesClient.syncBuild(siteFilter, (Run)this.target);
        }
    }

    public static class ItemJiraSyncAction
    extends JiraSyncAction<Item> {
        public ItemJiraSyncAction(SitesClient sitesClient, Item target) {
            super(sitesClient, target);
        }

        @Override
        public String getTargetDisplayName() {
            return ((Item)this.target).getFullDisplayName();
        }

        @Override
        protected void sync(Predicate<JiraSite> siteFilter) {
            this.sitesClient.syncJob(siteFilter, (Item)this.target);
        }
    }
}

