/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.security;

import com.nimbusds.jwt.JWTClaimsSet;
import hudson.security.ACL;
import javax.servlet.http.HttpServletRequest;
import org.marvelution.jji.configuration.JiraSite;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SyncTokenSecurityContext
implements SecurityContext {
    private static final String REQUEST_ATTRIBUTE = SyncTokenSecurityContext.class.getName();
    private final JWTClaimsSet claimsSet;
    private final JiraSite site;
    private Authentication authentication;

    public SyncTokenSecurityContext(JWTClaimsSet claimsSet, JiraSite site) {
        this.claimsSet = claimsSet;
        this.site = site;
        this.authentication = ACL.SYSTEM2;
    }

    public static SyncTokenSecurityContext checkSyncTokenAuthentication(HttpServletRequest request) {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context instanceof SyncTokenSecurityContext) {
            return (SyncTokenSecurityContext)context;
        }
        Object syncTokenSecurityContext = request.getAttribute(REQUEST_ATTRIBUTE);
        if (syncTokenSecurityContext instanceof SyncTokenSecurityContext) {
            return (SyncTokenSecurityContext)syncTokenSecurityContext;
        }
        throw new AccessDeniedException("Sync Token authentication required");
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public JWTClaimsSet getClaimsSet() {
        return this.claimsSet;
    }

    public JiraSite getSite() {
        return this.site;
    }

    void attachToRequest(HttpServletRequest request) {
        request.setAttribute(REQUEST_ATTRIBUTE, (Object)this);
    }

    void detachFromRequest(HttpServletRequest request) {
        request.removeAttribute(REQUEST_ATTRIBUTE);
    }
}

