/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.scm;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import hudson.Extension;
import hudson.MarkupText;
import hudson.model.Run;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.marvelution.jji.JiraUtils;
import org.marvelution.jji.SitesClient;

@Extension
public class JiraChangeLogAnnotator
extends ChangeLogAnnotator {
    private SitesClient client;
    private final LoadingCache<CacheKey, Map<String, String>> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<CacheKey, Map<String, String>>(){

        public Map<String, String> load(@Nonnull CacheKey cacheKey) {
            return JiraChangeLogAnnotator.this.client.getIssueLinks(cacheKey.jobHash, cacheKey.buildNumber);
        }
    });

    public void annotate(Run<?, ?> build, @Nullable ChangeLogSet.Entry entry, MarkupText markupText) {
        Map issueLinks = (Map)this.cache.getUnchecked((Object)new CacheKey(build));
        if (!issueLinks.isEmpty()) {
            Pattern pattern = Pattern.compile("(" + String.join((CharSequence)"|", issueLinks.keySet()) + ")");
            Matcher matcher = pattern.matcher(markupText.getText());
            while (matcher.find()) {
                if (!issueLinks.containsKey(matcher.group())) continue;
                markupText.addMarkup(matcher.start(), matcher.end(), "<a href='" + (String)issueLinks.get(matcher.group()) + "'>", "</a>");
            }
        }
    }

    @Inject
    public void setClient(SitesClient client) {
        this.client = client;
    }

    static class CacheKey {
        final String jobHash;
        final int buildNumber;

        CacheKey(String jobHash, int buildNumber) {
            this.jobHash = jobHash;
            this.buildNumber = buildNumber;
        }

        CacheKey(Run<?, ?> build) {
            this(JiraUtils.getJobHash(build), build.getNumber());
        }

        public int hashCode() {
            return Objects.hash(this.jobHash, this.buildNumber);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.buildNumber == cacheKey.buildNumber && Objects.equals(this.jobHash, cacheKey.jobHash);
        }
    }
}

