/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji;

import hudson.Plugin;
import hudson.PluginWrapper;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class JiraIntegrationPlugin {
    public static final String OLD_SHORT_NAME = "jenkins-jira-plugin";
    public static final String SHORT_NAME = "jira-integration";
    public static final String VERSION_HEADER = "X-JiraIntegration";
    private static final Logger LOGGER = Logger.getLogger(JiraIntegrationPlugin.class.getName());
    private static String VERSION = "?";

    public static String getVersion() {
        if (VERSION.equals("?")) {
            Plugin plugin = Jenkins.get().getPlugin(SHORT_NAME);
            if (plugin == null) {
                LOGGER.log(Level.WARNING, "Unable to locate plugin jira-integration");
            } else {
                VERSION = plugin.getWrapper().getVersion();
            }
        }
        return VERSION;
    }

    @Initializer(after=InitMilestone.STARTED)
    public static void init() throws Exception {
        Plugin plugin = Jenkins.get().getPlugin(OLD_SHORT_NAME);
        if (plugin != null) {
            LOGGER.warning(String.format("Plugin %s is installed, but should be disabled or uninstalled as it doesn't work with plugin %s.", OLD_SHORT_NAME, SHORT_NAME));
            PluginWrapper wrapper = plugin.getWrapper();
            LOGGER.warning(String.format("Attempting to disable plugin %s", OLD_SHORT_NAME));
            PluginWrapper.PluginDisableResult result = wrapper.disable(PluginWrapper.PluginDisableStrategy.NONE);
            if (result.getStatus() == PluginWrapper.PluginDisableStatus.DISABLED) {
                LOGGER.warning(String.format("Stopping plugin %s", OLD_SHORT_NAME));
                wrapper.stop();
                wrapper.releaseClassLoader();
                try {
                    LOGGER.warning(String.format("Uninstalling %s...", OLD_SHORT_NAME));
                    wrapper.doDoUninstall();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, String.format("Unable to uninstall %s: %s", OLD_SHORT_NAME, e.getMessage()), e);
                }
                LOGGER.warning("Triggering restart of Jenkins...");
                Jenkins.get().restart();
            } else {
                if (result.getStatus() != PluginWrapper.PluginDisableStatus.ALREADY_DISABLED) {
                    LOGGER.severe(String.format("Failed to disable %s, this plugin should be manually disabled followed by a restart of Jenkins", OLD_SHORT_NAME));
                    throw new IllegalStateException("Plugin " + plugin.getWrapper().getDisplayName() + " (jenkins-jira-plugin) needs to be uninstalled.");
                }
                LOGGER.info(String.format("Plugin %s is %s with message %s", OLD_SHORT_NAME, result.getStatus(), result.getMessage()));
            }
        } else {
            LOGGER.fine(String.format("No need to act, plugin %s was not found.", OLD_SHORT_NAME));
        }
    }
}

