/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog.actions;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Action;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class JFrogCliConfigEncryption
implements Action {
    private boolean shouldEncrypt;
    private String key;
    private String keyFilePath;

    public JFrogCliConfigEncryption(EnvVars env) {
        if (env.containsKey((Object)"JFROG_CLI_HOME_DIR")) {
            return;
        }
        this.shouldEncrypt = true;
        this.key = UUID.randomUUID().toString().replaceAll("-", "");
    }

    public String writeKeyFile(FilePath jfrogHomeTempDir) throws IOException, InterruptedException {
        if (this.key == null || this.key.isEmpty()) {
            return null;
        }
        if (this.keyFilePath != null) {
            return this.keyFilePath;
        }
        FilePath encryptionDir = jfrogHomeTempDir.child("encryption");
        encryptionDir.mkdirs();
        String fileName = UUID.randomUUID().toString() + ".key";
        FilePath keyFile = encryptionDir.child(fileName);
        keyFile.write(this.key, StandardCharsets.UTF_8.name());
        this.keyFilePath = keyFile.getRemote();
        return this.keyFilePath;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    public boolean shouldEncrypt() {
        return this.shouldEncrypt;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "JFrog CLI config encryption";
    }

    public String getUrlName() {
        return null;
    }
}

