/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Plugin;
import hudson.PluginWrapper;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import io.jenkins.plugins.jfrog.ReleasesInstaller;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class JfrogInstallation
extends ToolInstallation
implements NodeSpecific<JfrogInstallation>,
EnvironmentSpecific<JfrogInstallation> {
    public static final String JFROG_BINARY_PATH = "JFROG_BINARY_PATH";
    public static final String JFROG_CLI_DEPENDENCIES_DIR = "JFROG_CLI_DEPENDENCIES_DIR";
    public static final String JFROG_CLI_USER_AGENT = "JFROG_CLI_USER_AGENT";
    public static final String JfrogDependenciesDirName = "dependencies";

    @DataBoundConstructor
    public JfrogInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public JfrogInstallation forEnvironment(EnvVars environment) {
        return new JfrogInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public JfrogInstallation forNode(@NonNull Node node, TaskListener log) throws IOException, InterruptedException {
        return new JfrogInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public void buildEnvVars(EnvVars env) {
        Path path;
        String home = this.getHome();
        if (home == null) {
            return;
        }
        env.put(JFROG_BINARY_PATH, home);
        if (env.get((Object)JFROG_CLI_DEPENDENCIES_DIR) == null && (path = Paths.get(home, new String[0]).getParent()) != null) {
            env.put(JFROG_CLI_DEPENDENCIES_DIR, path.resolve(JfrogDependenciesDirName).toString());
        }
        env.putIfAbsent((Object)JFROG_CLI_USER_AGENT, (Object)("jenkins-jfrog-plugin" + this.getPluginVersion()));
    }

    private String getPluginVersion() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return "";
        }
        Plugin plugin = jenkins.getPlugin("jfrog");
        if (plugin == null) {
            return "";
        }
        PluginWrapper wrapper = plugin.getWrapper();
        if (wrapper == null) {
            return "";
        }
        String version = wrapper.getVersion();
        return "/" + version.split(" ")[0];
    }

    @Symbol(value={"jfrog"})
    @Extension
    public static final class DescriptorImpl
    extends ToolDescriptor<JfrogInstallation> {
        public DescriptorImpl() {
            super(JfrogInstallation.class);
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return "JFrog CLI";
        }

        public JfrogInstallation newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (JfrogInstallation)super.newInstance(req, formData.getJSONObject("jfrog"));
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            ArrayList<ReleasesInstaller> installersList = new ArrayList<ReleasesInstaller>();
            installersList.add(new ReleasesInstaller());
            return installersList;
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null && jenkins.hasPermission(Jenkins.ADMINISTER)) {
                super.configure(req, o);
                this.save();
                return true;
            }
            throw new Descriptor.FormException("User doesn't have permissions to save", "Server ID");
        }
    }
}

