/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import io.jenkins.plugins.insightappsec.MappingConfiguration;
import io.jenkins.plugins.insightappsec.api.Page;
import io.jenkins.plugins.insightappsec.exception.APIException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;

public abstract class AbstractApi {
    private static final String X_API_KEY_HEADER = "x-api-key";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String USER_AGENT_HEADER_VALUE = "r7:insightappsec-jenkins-extension/1.0.5";
    private final HttpClient client;
    private final String host;
    private final String apiKey;

    protected AbstractApi(HttpClient client, String host, String apiKey) {
        this.client = client;
        this.host = host;
        this.apiKey = apiKey;
    }

    protected String post(String path, Object body) {
        HttpResponse response;
        block6: {
            response = null;
            URI uri = this.buildUri(path);
            HttpPost post = this.createPost(uri, body);
            response = this.client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 201) break block6;
            String locationHeader = response.getHeaders("Location")[0].getValue();
            String string = locationHeader.substring(locationHeader.lastIndexOf(47) + 1);
            this.freeConnectionForReuse(response);
            return string;
        }
        try {
            try {
                throw new APIException(String.format("Error occurred during POST of [%s]. Expected status code [%s]. Response was: %n %s", body.getClass().getSimpleName(), 201, response), response);
            }
            catch (APIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new APIException(String.format("Error occurred during POST of [%s]", body.getClass().getName()), e);
            }
        }
        catch (Throwable throwable) {
            this.freeConnectionForReuse(response);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void put(String path, Object body) {
        HttpResponse response = null;
        try {
            URI uri = this.buildUri(path);
            HttpPut put = this.createPut(uri, body);
            response = this.client.execute((HttpUriRequest)put);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new APIException(String.format("Error occurred during PUT of [%s]. Expected status code [%s]. Response was: %n %s", body.getClass().getSimpleName(), 200, response), response);
            }
        }
        catch (APIException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new APIException(String.format("Error occurred during PUT of [%s]", body.getClass().getName()), e2);
                }
            }
            catch (Throwable throwable) {
                this.freeConnectionForReuse(response);
                throw throwable;
            }
        }
        this.freeConnectionForReuse(response);
    }

    protected <T> T getById(String path, String id, Class<T> clazz) {
        HttpResponse response;
        block6: {
            response = null;
            URI uri = this.buildUri(path);
            HttpGet get = this.createGet(uri);
            response = this.client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) break block6;
            String content = IOUtils.toString((InputStream)response.getEntity().getContent());
            Object object = MappingConfiguration.OBJECT_MAPPER_INSTANCE.readValue(content, clazz);
            this.freeConnectionForReuse(response);
            return (T)object;
        }
        try {
            try {
                throw new APIException(String.format("Error occurred during GET for [%s] with id [%s]. Expected status code [%s]. Response was: %n %s", clazz.getSimpleName(), id, 200, response), response);
            }
            catch (APIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new APIException(String.format("Error occurred during GET for [%s] with id [%s]", clazz.getSimpleName(), id), e);
            }
        }
        catch (Throwable throwable) {
            this.freeConnectionForReuse(response);
            throw throwable;
        }
    }

    protected <T> List<T> getForAll(String path, Class<T> clazz) {
        return this.retrieveAll(index -> {
            URI uri = this.buildUriWithIndex(path, (int)index);
            HttpGet get = this.createGet(uri);
            return this.retrievePage(clazz, (HttpUriRequest)get);
        });
    }

    protected <T> List<T> postForAll(String path, Class<T> clazz, Object body) {
        return this.retrieveAll(index -> {
            URI uri = this.buildUriWithIndex(path, (int)index);
            HttpPost post = this.createPost(uri, body);
            return this.retrievePage(clazz, (HttpUriRequest)post);
        });
    }

    private void freeConnectionForReuse(HttpResponse response) {
        if (response != null) {
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                throw new APIException("Error occurred releasing a connection", e);
            }
        }
    }

    private URI buildUri(String path) {
        return this.buildUri(path, new HashMap<String, String>());
    }

    private URI buildUriWithIndex(String path, int index) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("index", String.valueOf(index));
        params.put("size", "1000");
        return this.buildUri(path, params);
    }

    private URI buildUri(String path, Map<String, String> params) {
        try {
            URIBuilder builder = new URIBuilder(String.format("https://%s/ias/v1%s", this.host, path));
            params.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new APIException("Error occurred building URI", e);
        }
    }

    private HttpPost createPost(URI uri, Object body) {
        HttpPost post = new HttpPost(uri);
        this.addApiKey((AbstractHttpMessage)post);
        this.addUserAgent((AbstractHttpMessage)post);
        this.addBody((HttpEntityEnclosingRequestBase)post, body);
        return post;
    }

    private HttpPut createPut(URI uri, Object body) {
        HttpPut put = new HttpPut(uri);
        this.addApiKey((AbstractHttpMessage)put);
        this.addUserAgent((AbstractHttpMessage)put);
        this.addBody((HttpEntityEnclosingRequestBase)put, body);
        return put;
    }

    private HttpGet createGet(URI uri) {
        HttpGet get = new HttpGet(uri);
        this.addApiKey((AbstractHttpMessage)get);
        this.addUserAgent((AbstractHttpMessage)get);
        return get;
    }

    private void addApiKey(AbstractHttpMessage request) {
        request.addHeader(X_API_KEY_HEADER, this.apiKey);
    }

    private void addBody(HttpEntityEnclosingRequestBase request, Object body) {
        try {
            String json = MappingConfiguration.OBJECT_MAPPER_INSTANCE.writeValueAsString(body);
            request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        }
        catch (JsonProcessingException e) {
            throw new APIException("Error occurred writing body as json", e);
        }
    }

    private void addUserAgent(AbstractHttpMessage request) {
        request.addHeader(USER_AGENT_HEADER, USER_AGENT_HEADER_VALUE);
    }

    private <T> List<T> retrieveAll(Function<Integer, Page<T>> getPageByIndex) {
        int index = 0;
        Page<T> page = getPageByIndex.apply(index);
        int totalPages = page.getMetadata().getTotalPages();
        if (totalPages == 0) {
            return new ArrayList();
        }
        ArrayList<T> all = new ArrayList<T>(page.getData());
        ++index;
        while (index < totalPages) {
            all.addAll(getPageByIndex.apply(index).getData());
            ++index;
        }
        return all;
    }

    private <T> Page<T> retrievePage(Class<T> clazz, HttpUriRequest request) {
        HttpResponse response = null;
        try {
            response = this.client.execute(request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                JavaType type = MappingConfiguration.OBJECT_MAPPER_INSTANCE.getTypeFactory().constructParametricType(Page.class, new Class[]{clazz});
                Page page = (Page)MappingConfiguration.OBJECT_MAPPER_INSTANCE.readValue(content, type);
                return page;
            }
            try {
                throw new APIException(String.format("Error occurred during retrieval of page of [%s]. Expected status code [%s]. Response was: %n %s", clazz.getSimpleName(), 200, response), response);
            }
            catch (APIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new APIException(String.format("Error occurred during retrieval of page of [%s]", clazz.getSimpleName()), e);
            }
        }
        finally {
            this.freeConnectionForReuse(response);
        }
    }
}

