/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec.api;

import io.jenkins.plugins.insightappsec.Region;
import io.jenkins.plugins.insightappsec.api.app.AppApi;
import io.jenkins.plugins.insightappsec.api.scan.ScanApi;
import io.jenkins.plugins.insightappsec.api.search.SearchApi;
import io.jenkins.plugins.insightappsec.credentials.InsightCredentialsHelper;
import org.apache.http.client.HttpClient;

public class APIFactory {
    private final InsightCredentialsHelper insightCredentialsHelper;
    private final HttpClient searchApiHttpClient;
    private final HttpClient appApiHttpClient;
    private final HttpClient scanApiHttpClient;

    public APIFactory(InsightCredentialsHelper insightCredentialsHelper, HttpClient searchApiHttpClient, HttpClient appApiHttpClient, HttpClient scanApiHttpClient) {
        this.insightCredentialsHelper = insightCredentialsHelper;
        this.searchApiHttpClient = searchApiHttpClient;
        this.appApiHttpClient = appApiHttpClient;
        this.scanApiHttpClient = scanApiHttpClient;
    }

    public SearchApi newSearchApi(String regionString, String insightCredentialsId) {
        return new SearchApi(this.searchApiHttpClient, this.getHost(regionString), this.getApiKey(insightCredentialsId));
    }

    public AppApi newAppApi(String regionString, String insightCredentialsId) {
        return new AppApi(this.appApiHttpClient, this.getHost(regionString), this.getApiKey(insightCredentialsId));
    }

    public ScanApi newScanApi(String regionString, String insightCredentialsId) {
        return new ScanApi(this.scanApiHttpClient, this.getHost(regionString), this.getApiKey(insightCredentialsId));
    }

    private String getHost(String regionString) {
        return Region.fromString(regionString).getAPIHost();
    }

    private String getApiKey(String insightCredentialsId) {
        return this.insightCredentialsHelper.lookupInsightCredentialsById(insightCredentialsId).getApiKey().getPlainText();
    }
}

