/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class DurationStringParser {
    private static final int NON_EXISTENT_STRING_INDEX = -1;

    public Long parseDurationString(String durationString) {
        if (StringUtils.isBlank((CharSequence)durationString)) {
            return null;
        }
        try {
            int dayIndex = durationString.indexOf("d");
            int hourIndex = durationString.indexOf("h");
            int minuteIndex = durationString.indexOf("m");
            if (dayIndex == -1 || hourIndex == -1 || minuteIndex == -1) {
                throw new IllegalArgumentException();
            }
            if (durationString.charAt(dayIndex + 1) != ' ' || durationString.charAt(hourIndex + 1) != ' ') {
                throw new IllegalArgumentException();
            }
            int dayQuantity = Integer.parseInt(durationString.substring(0, dayIndex));
            int hourQuantity = Integer.parseInt(durationString.substring(dayIndex + 2, hourIndex));
            int minuteQuantity = Integer.parseInt(durationString.substring(hourIndex + 2, minuteIndex));
            Long duration = TimeUnit.DAYS.toMillis(dayQuantity) + TimeUnit.HOURS.toMillis(hourQuantity) + TimeUnit.MINUTES.toMillis(minuteQuantity);
            if (duration < 0L) {
                throw new IllegalArgumentException("Negative duration is not permitted");
            }
            return duration;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

