/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gparams;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import io.jenkins.plugins.gparams.Parameters;
import io.jenkins.plugins.gparams.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class GParamsReadStep
extends Step {
    private final String name;

    @DataBoundConstructor
    public GParamsReadStep(String name) {
        if (!Utils.isValidParameterName(name)) {
            throw new IllegalArgumentException("The '" + name + "' is not a valid gparams variable name");
        }
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    private static class Execution
    extends SynchronousStepExecution<String> {
        private final transient GParamsReadStep step;
        private static final long serialVersionUID = 1L;

        public Execution(GParamsReadStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        protected String run() throws Exception {
            String name = this.step.getName();
            if (!Utils.isValidParameterName(name)) {
                throw new IllegalArgumentException("The '" + name + "' is not a valid gparams variable name");
            }
            String filePath = Parameters.GParamDirectoryName + name;
            try {
                File file = new File(filePath);
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    String string;
                    block14: {
                        FileLock lock = fileInputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
                        try {
                            string = new String(fileInputStream.readAllBytes(), StandardCharsets.UTF_8);
                            if (lock == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (lock != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        lock.close();
                    }
                    return string;
                }
            }
            catch (IOException e) {
                throw new IOException("gparam parameter " + name + " not exist");
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "gpRead";
        }

        @NonNull
        public String getDisplayName() {
            return "Read global parameter";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

