/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabchecks;

import io.jenkins.plugins.checks.api.ChecksDetails;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Optional;
import org.gitlab4j.api.models.CommitStatus;
import org.gitlab4j.models.Constants;
import org.jspecify.annotations.NonNull;

public class CheckStatusToGitLabCommitStatus {
    public static Optional<CommitStatus> makeCommitStatus(@NonNull ChecksDetails check) {
        Optional name = check.getName();
        if (name.isEmpty()) {
            return Optional.empty();
        }
        CommitStatus status = new CommitStatus();
        status.setName((String)name.get());
        check.getDetailsURL().ifPresent(arg_0 -> ((CommitStatus)status).setTargetUrl(arg_0));
        check.getOutput().ifPresent(output -> {
            output.getSummary().ifPresent(arg_0 -> ((CommitStatus)status).setDescription(arg_0));
            output.getTitle().ifPresent(arg_0 -> ((CommitStatus)status).setStatus(arg_0));
        });
        check.getStartedAt().map(d -> Date.from(d.toInstant(ZoneOffset.UTC))).ifPresent(arg_0 -> ((CommitStatus)status).setStartedAt(arg_0));
        check.getCompletedAt().map(d -> Date.from(d.toInstant(ZoneOffset.UTC))).ifPresent(arg_0 -> ((CommitStatus)status).setFinishedAt(arg_0));
        return Optional.of(status);
    }

    public static Optional<Constants.CommitBuildState> makeBuildStatus(@NonNull ChecksDetails details) {
        switch (details.getStatus()) {
            case NONE: 
            case QUEUED: {
                return Optional.of(Constants.CommitBuildState.PENDING);
            }
            case IN_PROGRESS: {
                return Optional.of(Constants.CommitBuildState.RUNNING);
            }
            case COMPLETED: {
                switch (details.getConclusion()) {
                    case NONE: 
                    case ACTION_REQUIRED: {
                        return Optional.of(Constants.CommitBuildState.PENDING);
                    }
                    case SKIPPED: {
                        return Optional.of(Constants.CommitBuildState.SKIPPED);
                    }
                    case CANCELED: {
                        return Optional.of(Constants.CommitBuildState.CANCELED);
                    }
                    case TIME_OUT: 
                    case FAILURE: {
                        return Optional.of(Constants.CommitBuildState.FAILED);
                    }
                    case NEUTRAL: 
                    case SUCCESS: {
                        return Optional.of(Constants.CommitBuildState.SUCCESS);
                    }
                }
            }
        }
        return Optional.empty();
    }
}

