/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.github;

import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.checks.github.GitHubChecksContext;
import io.jenkins.plugins.checks.github.SCMFacade;
import java.util.Optional;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;

class GitHubSCMSourceChecksContext
extends GitHubChecksContext {
    @CheckForNull
    private final String sha;
    @CheckForNull
    private final Run<?, ?> run;

    static GitHubSCMSourceChecksContext fromRun(Run<?, ?> run, String runURL, SCMFacade scmFacade) {
        return new GitHubSCMSourceChecksContext(run.getParent(), run, runURL, scmFacade);
    }

    static GitHubSCMSourceChecksContext fromJob(Job<?, ?> job, String runURL, SCMFacade scmFacade) {
        return new GitHubSCMSourceChecksContext(job, null, runURL, scmFacade);
    }

    private GitHubSCMSourceChecksContext(Job<?, ?> job, @CheckForNull Run<?, ?> run, String runURL, SCMFacade scmFacade) {
        super(job, runURL, scmFacade);
        this.run = run;
        this.sha = Optional.ofNullable(run).map(this::resolveHeadSha).orElse(this.resolveHeadSha(job));
    }

    @Override
    public String getHeadSha() {
        if (StringUtils.isBlank((CharSequence)this.sha)) {
            throw new IllegalStateException("No SHA found for job: " + this.getJob().getName());
        }
        return this.sha;
    }

    @Override
    public String getRepository() {
        GitHubSCMSource source = this.resolveSource();
        if (source == null) {
            throw new IllegalStateException("No GitHub SCM source found for job: " + this.getJob().getName());
        }
        return source.getRepoOwner() + "/" + source.getRepository();
    }

    String getOwner() {
        return Optional.ofNullable(this.resolveSource()).map(GitHubSCMSource::getRepoOwner).orElse(null);
    }

    @Override
    public boolean isValid(FilteredLog logger) {
        logger.logError("Trying to resolve checks parameters from GitHub SCM...");
        if (this.resolveSource() == null) {
            logger.logError("Job does not use GitHub SCM");
            return false;
        }
        if (!this.hasValidCredentials(logger)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.sha)) {
            logger.logError("No HEAD SHA found for %s", new Object[]{this.getRepository()});
            return false;
        }
        return true;
    }

    @Override
    protected Optional<Run<?, ?>> getRun() {
        return Optional.ofNullable(this.run);
    }

    @Override
    @CheckForNull
    protected String getCredentialsId() {
        GitHubSCMSource source = this.resolveSource();
        if (source == null) {
            return null;
        }
        return source.getCredentialsId();
    }

    @CheckForNull
    private GitHubSCMSource resolveSource() {
        return this.getScmFacade().findGitHubSCMSource(this.getJob()).orElse(null);
    }

    @CheckForNull
    private String resolveHeadSha(Run<?, ?> theRun) {
        Optional<SCMRevision> revision;
        GitHubSCMSource source = this.resolveSource();
        if (source != null && (revision = this.getScmFacade().findRevision(source, theRun)).isPresent()) {
            return this.getScmFacade().findHash(revision.get()).orElse(null);
        }
        return null;
    }

    @CheckForNull
    private String resolveHeadSha(Job<?, ?> job) {
        Optional<SCMRevision> revision;
        GitHubSCMSource source = this.resolveSource();
        Optional<SCMHead> head = this.getScmFacade().findHead(job);
        if (source != null && head.isPresent() && (revision = this.getScmFacade().findRevision((SCMSource)source, head.get())).isPresent()) {
            return this.getScmFacade().findHash(revision.get()).orElse(null);
        }
        return null;
    }
}

