/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.github;

import io.jenkins.plugins.checks.api.ChecksAction;
import io.jenkins.plugins.checks.api.ChecksAnnotation;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksImage;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksStatus;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCheckRunBuilder;

class GitHubChecksDetails {
    private final ChecksDetails details;
    private static final int MAX_MESSAGE_SIZE_TO_CHECKS_API = 65535;

    GitHubChecksDetails(ChecksDetails details) {
        if (details.getConclusion() == ChecksConclusion.NONE) {
            if (details.getStatus() == ChecksStatus.COMPLETED) {
                throw new IllegalArgumentException("No conclusion has been set when status is completed.");
            }
            if (details.getCompletedAt().isPresent()) {
                throw new IllegalArgumentException("No conclusion has been set when \"completedAt\" is provided.");
            }
        }
        this.details = details;
    }

    public String getName() {
        return this.details.getName().filter(StringUtils::isNotBlank).orElseThrow(() -> new IllegalArgumentException("The check name is blank."));
    }

    public GHCheckRun.Status getStatus() {
        return switch (this.details.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case ChecksStatus.NONE, ChecksStatus.QUEUED -> GHCheckRun.Status.QUEUED;
            case ChecksStatus.IN_PROGRESS -> GHCheckRun.Status.IN_PROGRESS;
            case ChecksStatus.COMPLETED -> GHCheckRun.Status.COMPLETED;
        };
    }

    public Optional<String> getDetailsURL() {
        if (this.details.getDetailsURL().filter(StringUtils::isBlank).isPresent()) {
            return Optional.empty();
        }
        this.details.getDetailsURL().ifPresent(url -> {
            if (!StringUtils.equalsAny((CharSequence)URI.create(url).getScheme(), (CharSequence[])new CharSequence[]{"http", "https"})) {
                throw new IllegalArgumentException("The details url is not http or https scheme: " + url);
            }
        });
        return this.details.getDetailsURL();
    }

    public Optional<Date> getStartedAt() {
        if (this.details.getStartedAt().isPresent()) {
            return Optional.of(Date.from(((LocalDateTime)this.details.getStartedAt().get()).toInstant(ZoneOffset.UTC)));
        }
        return Optional.empty();
    }

    public Optional<GHCheckRun.Conclusion> getConclusion() {
        return switch (this.details.getConclusion()) {
            default -> throw new IncompatibleClassChangeError();
            case ChecksConclusion.SKIPPED -> Optional.of(GHCheckRun.Conclusion.SKIPPED);
            case ChecksConclusion.FAILURE, ChecksConclusion.CANCELED, ChecksConclusion.TIME_OUT -> Optional.of(GHCheckRun.Conclusion.FAILURE);
            case ChecksConclusion.NEUTRAL -> Optional.of(GHCheckRun.Conclusion.NEUTRAL);
            case ChecksConclusion.SUCCESS -> Optional.of(GHCheckRun.Conclusion.SUCCESS);
            case ChecksConclusion.ACTION_REQUIRED -> Optional.of(GHCheckRun.Conclusion.ACTION_REQUIRED);
            case ChecksConclusion.NONE -> Optional.empty();
        };
    }

    public Optional<Date> getCompletedAt() {
        if (this.details.getCompletedAt().isPresent()) {
            return Optional.of(Date.from(((LocalDateTime)this.details.getCompletedAt().get()).toInstant(ZoneOffset.UTC)));
        }
        return Optional.empty();
    }

    public Optional<GHCheckRunBuilder.Output> getOutput() {
        if (this.details.getOutput().isPresent()) {
            ChecksOutput checksOutput = (ChecksOutput)this.details.getOutput().get();
            GHCheckRunBuilder.Output output = new GHCheckRunBuilder.Output((String)checksOutput.getTitle().orElseThrow(() -> new IllegalArgumentException("Title of output is required but not provided")), (String)checksOutput.getSummary(65535).orElseThrow(() -> new IllegalArgumentException("Summary of output is required but not provided"))).withText((String)checksOutput.getText(65535).orElse(null));
            checksOutput.getChecksAnnotations().stream().map(this::getAnnotation).forEach(arg_0 -> ((GHCheckRunBuilder.Output)output).add(arg_0));
            checksOutput.getChecksImages().stream().map(this::getImage).forEach(arg_0 -> ((GHCheckRunBuilder.Output)output).add(arg_0));
            return Optional.of(output);
        }
        return Optional.empty();
    }

    public List<GHCheckRunBuilder.Action> getActions() {
        return this.details.getActions().stream().map(this::getAction).collect(Collectors.toList());
    }

    private GHCheckRunBuilder.Action getAction(ChecksAction checksAction) {
        return new GHCheckRunBuilder.Action((String)checksAction.getLabel().orElseThrow(() -> new IllegalArgumentException("Label of action is required but not provided")), (String)checksAction.getDescription().orElseThrow(() -> new IllegalArgumentException("Description of action is required but not provided")), (String)checksAction.getIdentifier().orElseThrow(() -> new IllegalArgumentException("Identifier of action is required but not provided")));
    }

    private GHCheckRunBuilder.Annotation getAnnotation(ChecksAnnotation checksAnnotation) {
        return new GHCheckRunBuilder.Annotation((String)checksAnnotation.getPath().orElseThrow(() -> new IllegalArgumentException("Path is required but not provided.")), ((Integer)checksAnnotation.getStartLine().orElseThrow(() -> new IllegalArgumentException("Start line is required but not provided."))).intValue(), ((Integer)checksAnnotation.getEndLine().orElseThrow(() -> new IllegalArgumentException("End line is required but not provided."))).intValue(), this.getAnnotationLevel(checksAnnotation.getAnnotationLevel()), (String)checksAnnotation.getMessage().orElseThrow(() -> new IllegalArgumentException("Message is required but not provided."))).withTitle((String)checksAnnotation.getTitle().orElse(null)).withRawDetails((String)checksAnnotation.getRawDetails().orElse(null)).withStartColumn((Integer)checksAnnotation.getStartColumn().orElse(null)).withEndColumn((Integer)checksAnnotation.getEndColumn().orElse(null));
    }

    private GHCheckRunBuilder.Image getImage(ChecksImage checksImage) {
        return new GHCheckRunBuilder.Image((String)checksImage.getAlt().orElseThrow(() -> new IllegalArgumentException("alt of image is required but not provided.")), (String)checksImage.getImageUrl().orElseThrow(() -> new IllegalArgumentException("url of image is required but not provided."))).withCaption((String)checksImage.getCaption().orElse(null));
    }

    private GHCheckRun.AnnotationLevel getAnnotationLevel(ChecksAnnotation.ChecksAnnotationLevel checksLevel) {
        return switch (checksLevel) {
            default -> throw new IncompatibleClassChangeError();
            case ChecksAnnotation.ChecksAnnotationLevel.NOTICE -> GHCheckRun.AnnotationLevel.NOTICE;
            case ChecksAnnotation.ChecksAnnotationLevel.FAILURE -> GHCheckRun.AnnotationLevel.FAILURE;
            case ChecksAnnotation.ChecksAnnotationLevel.WARNING -> GHCheckRun.AnnotationLevel.WARNING;
            case ChecksAnnotation.ChecksAnnotationLevel.NONE -> throw new IllegalArgumentException("Annotation level is required but not set.");
        };
    }
}

