/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.gitea;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.gitea.GitSCMChecksContext;
import io.jenkins.plugins.checks.gitea.GiteaChecksContext;
import io.jenkins.plugins.checks.gitea.GiteaChecksPublisher;
import io.jenkins.plugins.checks.gitea.GiteaSCMSourceChecksContext;
import io.jenkins.plugins.checks.gitea.SCMFacade;
import io.jenkins.plugins.util.PluginLogger;
import java.util.Collection;
import java.util.Optional;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

@Extension
public class GiteaPublisherFactory
extends ChecksPublisherFactory {
    private final SCMFacade scmFacade;
    private final DisplayURLProvider urlProvider;

    public GiteaPublisherFactory() {
        this(new SCMFacade(), DisplayURLProvider.get());
    }

    @VisibleForTesting
    GiteaPublisherFactory(SCMFacade scmFacade, DisplayURLProvider urlProvider) {
        this.scmFacade = scmFacade;
        this.urlProvider = urlProvider;
    }

    protected Optional<ChecksPublisher> createPublisher(Run<?, ?> run, TaskListener listener) {
        String runURL = this.urlProvider.getRunURL(run);
        return this.createPublisher(listener, GiteaSCMSourceChecksContext.fromRun(run, runURL, this.scmFacade), new GitSCMChecksContext(run, runURL, this.scmFacade));
    }

    protected Optional<ChecksPublisher> createPublisher(Job<?, ?> job, TaskListener listener) {
        return this.createPublisher(listener, GiteaSCMSourceChecksContext.fromJob(job, this.urlProvider.getJobURL(job), this.scmFacade));
    }

    private Optional<ChecksPublisher> createPublisher(TaskListener listener, GiteaChecksContext ... contexts) {
        FilteredLog causeLogger = new FilteredLog("Causes for no suitable publisher found: ");
        PluginLogger consoleLogger = new PluginLogger(listener.getLogger(), "Gitea Checks");
        for (GiteaChecksContext ctx : contexts) {
            if (!ctx.isValid(causeLogger)) continue;
            return Optional.of(new GiteaChecksPublisher(ctx, consoleLogger));
        }
        consoleLogger.logEachLine((Collection)causeLogger.getErrorMessages());
        return Optional.empty();
    }
}

