/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.delta;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import io.jenkins.plugins.forensics.delta.DeltaCalculator;
import io.jenkins.plugins.forensics.delta.DeltaCalculatorFactory;
import io.jenkins.plugins.forensics.git.delta.GitDeltaCalculator;
import io.jenkins.plugins.forensics.git.util.GitRepositoryValidator;
import java.util.Optional;
import org.jenkinsci.plugins.gitclient.GitClient;

@Extension
public class GitDeltaCalculatorFactory
extends DeltaCalculatorFactory {
    public Optional<DeltaCalculator> createDeltaCalculator(SCM scm, Run<?, ?> run, FilePath workspace, TaskListener listener, FilteredLog logger) {
        GitRepositoryValidator validator = new GitRepositoryValidator(scm, run, workspace, listener, logger);
        if (validator.isGitRepository()) {
            GitClient client = validator.createClient();
            logger.logInfo("-> Git delta calculator successfully created for SCM '%s' in working tree '%s'", new Object[]{scm, new PathUtil().getAbsolutePath(client.getWorkTree().getRemote())});
            return Optional.of(new GitDeltaCalculator(client, scm.getKey()));
        }
        logger.logInfo("-> Git Delta Calculator could not be created for SCM '%s' in working tree '%s'", new Object[]{scm, workspace});
        return Optional.empty();
    }
}

