/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.delta;

import edu.hm.hafner.util.Generated;
import io.jenkins.plugins.forensics.git.delta.GitDelta;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractObjectAssert;

@Generated(value={"assertj-assertions-generator"})
public class GitDeltaAssert
extends AbstractObjectAssert<GitDeltaAssert, GitDelta> {
    public GitDeltaAssert(GitDelta actual) {
        super((Object)actual, GitDeltaAssert.class);
    }

    @CheckReturnValue
    public static GitDeltaAssert assertThat(GitDelta actual) {
        return new GitDeltaAssert(actual);
    }

    public GitDeltaAssert hasCurrentCommit(String currentCommit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting currentCommit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualCurrentCommit = ((GitDelta)this.actual).getCurrentCommit();
        if (!Objects.deepEquals(actualCurrentCommit, currentCommit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, currentCommit, actualCurrentCommit});
        }
        return this;
    }

    public GitDeltaAssert hasDiffFile(String diffFile) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting diffFile of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDiffFile = ((GitDelta)this.actual).getDiffFile();
        if (!Objects.deepEquals(actualDiffFile, diffFile)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, diffFile, actualDiffFile});
        }
        return this;
    }

    public GitDeltaAssert hasFileChangesMap(Map fileChangesMap) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileChangesMap of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualFileChangesMap = ((GitDelta)this.actual).getFileChangesMap();
        if (!Objects.deepEquals(actualFileChangesMap, fileChangesMap)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileChangesMap, actualFileChangesMap});
        }
        return this;
    }

    public GitDeltaAssert hasReferenceCommit(String referenceCommit) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting referenceCommit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualReferenceCommit = ((GitDelta)this.actual).getReferenceCommit();
        if (!Objects.deepEquals(actualReferenceCommit, referenceCommit)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, referenceCommit, actualReferenceCommit});
        }
        return this;
    }
}

