/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.generic.event.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;
import net.sf.json.processors.JsonBeanProcessorMatcher;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.ExportConfig;
import org.kohsuke.stapler.export.ExportInterceptor;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.Property;

public class ExportedBeanProcessor
implements JsonBeanProcessor {
    private final Logger logger = Logger.getLogger(ExportedBeanProcessor.class.getName());

    public JSONObject processBean(Object value, JsonConfig jsonConfig) {
        StringWriter stringWriter = new StringWriter();
        try {
            ExportConfig exportConfig = new ExportConfig().withExportInterceptor((ExportInterceptor)new IgnoreURLExportInterceptor());
            DataWriter dataWriter = Flavor.JSON.createDataWriter(value, (Writer)stringWriter, exportConfig);
            Model model = new ModelBuilder().get(value.getClass());
            model.writeTo(value, dataWriter);
            return JSONObject.fromObject((Object)stringWriter.toString());
        }
        catch (IOException e) {
            throw new JSONException("Failed to serialize @Exported model", (Throwable)e);
        }
    }

    public static class IgnoreURLExportInterceptor
    extends ExportInterceptor {
        public Object getValue(Property property, Object model, ExportConfig config) throws IOException {
            if (property.name.equals("url")) {
                return SKIP;
            }
            return DEFAULT.getValue(property, model, config);
        }
    }

    public static class Matcher
    extends JsonBeanProcessorMatcher {
        public Object getMatch(Class target, Set set) {
            if (target != null && target.isAnnotationPresent(ExportedBean.class)) {
                return ExportedBean.class;
            }
            return DEFAULT.getMatch(target, set);
        }
    }
}

