/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.generic.event.data;

import io.jenkins.plugins.generic.event.transformer.EnhancedData;
import java.util.Objects;
import jenkins.branch.MultiBranchProject;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.export.Exported;

public class WorkflowRunData
extends EnhancedData<WorkflowRun> {
    private String parentFullName;
    private String projectName;
    private boolean isMultiBranch;
    private final WorkflowRun run;

    public WorkflowRunData(WorkflowRun run) {
        this.run = run;
        WorkflowJob project = (WorkflowJob)run.getParent();
        this.setProjectName(project.getName());
        this.setParentFullName(project.getParent().getFullName());
        if (project.getParent() instanceof MultiBranchProject) {
            this.setMultiBranch(true);
        }
    }

    @Exported(name="_parentFullName")
    public String getParentFullName() {
        return this.parentFullName;
    }

    public void setParentFullName(String parentFullName) {
        this.parentFullName = parentFullName;
    }

    @Exported(name="_projectName")
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Exported(name="_multiBranch")
    public boolean isMultiBranch() {
        return this.isMultiBranch;
    }

    public void setMultiBranch(boolean isMultiBranch) {
        this.isMultiBranch = isMultiBranch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowRunData that = (WorkflowRunData)o;
        return this.isMultiBranch == that.isMultiBranch && Objects.equals(this.parentFullName, that.parentFullName) && Objects.equals(this.projectName, that.projectName) && Objects.equals(this.run, that.run);
    }

    public int hashCode() {
        return Objects.hash(this.parentFullName, this.projectName, this.isMultiBranch, this.run);
    }

    public String toString() {
        return "WorkflowRunData{parentFullName='" + this.parentFullName + "', projectName='" + this.projectName + "', isMultiBranch=" + this.isMultiBranch + ", run=" + String.valueOf(this.run) + "}";
    }

    @Override
    public WorkflowRun getRaw() {
        return this.run;
    }
}

