/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth.roles;

import io.jenkins.plugins.folderauth.misc.PermissionWrapper;
import io.jenkins.plugins.folderauth.roles.AbstractRole;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;

public class FolderRole
extends AbstractRole {
    @Nonnull
    private final Set<String> folders;

    @DataBoundConstructor
    public FolderRole(String name, Set<PermissionWrapper> permissions, Set<String> folders, Set<String> sids) {
        super(name, permissions, sids);
        this.folders = new HashSet<String>(folders);
    }

    public FolderRole(String name, Set<PermissionWrapper> permissions, Set<String> folders) {
        this(name, permissions, folders, Collections.emptySet());
    }

    @Nonnull
    public Set<String> getFolderNames() {
        return Collections.unmodifiableSet(this.folders);
    }

    @Nonnull
    public String getFolderNamesCommaSeparated() {
        String csv = new TreeSet<String>(this.folders).toString();
        return csv.substring(1, csv.length() - 1);
    }
}

