/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.SidACL;
import io.jenkins.plugins.folderauth.FolderAuthorizationStrategyManagementLink;
import io.jenkins.plugins.folderauth.Messages;
import io.jenkins.plugins.folderauth.acls.GenericAclImpl;
import io.jenkins.plugins.folderauth.acls.GlobalAclImpl;
import io.jenkins.plugins.folderauth.misc.PermissionWrapper;
import io.jenkins.plugins.folderauth.roles.AbstractRole;
import io.jenkins.plugins.folderauth.roles.AgentRole;
import io.jenkins.plugins.folderauth.roles.FolderRole;
import io.jenkins.plugins.folderauth.roles.GlobalRole;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

@ParametersAreNonnullByDefault
public class FolderBasedAuthorizationStrategy
extends AuthorizationStrategy {
    private static final String ADMIN_ROLE_NAME = "admin";
    private static final String FOLDER_SEPARATOR = "/";
    private final Set<AgentRole> agentRoles;
    private final Set<GlobalRole> globalRoles;
    private final Set<FolderRole> folderRoles;
    private transient GlobalAclImpl globalAcl;
    private transient ConcurrentHashMap<String, GenericAclImpl> jobAcls;
    private transient ConcurrentHashMap<String, GenericAclImpl> agentAcls;
    private transient Cache<String, SidACL> jobAclCache;

    @DataBoundConstructor
    public FolderBasedAuthorizationStrategy(Set<GlobalRole> globalRoles, Set<FolderRole> folderRoles, Set<AgentRole> agentRoles) {
        this.agentRoles = new HashSet<AgentRole>(agentRoles);
        this.globalRoles = new HashSet<GlobalRole>(globalRoles);
        this.folderRoles = new HashSet<FolderRole>(folderRoles);
        this.init();
    }

    private void updateJobAcls() {
        this.jobAcls.clear();
        for (FolderRole role : this.folderRoles) {
            this.updateAclForFolderRole(role);
        }
    }

    private synchronized void updateAgentAcls() {
        this.agentAcls.clear();
        for (AgentRole role : this.agentRoles) {
            this.updateAclForAgentRole(role);
        }
    }

    @Nonnull
    public GlobalAclImpl getRootACL() {
        return this.globalAcl;
    }

    @Nonnull
    private FolderBasedAuthorizationStrategy readResolve() {
        this.init();
        return this;
    }

    @Nonnull
    public SidACL getACL(Job<?, ?> project) {
        return this.getACL((AbstractItem)project);
    }

    @Nonnull
    public SidACL getACL(AbstractItem item) {
        String fullName = item.getFullName();
        SidACL acl = (SidACL)this.jobAclCache.getIfPresent((Object)fullName);
        if (acl != null) {
            return acl;
        }
        String[] splits = fullName.split(FOLDER_SEPARATOR);
        StringBuilder sb = new StringBuilder(fullName.length());
        acl = this.globalAcl;
        for (String str : splits) {
            sb.append(str);
            SidACL newAcl = this.jobAcls.get(sb.toString());
            if (newAcl != null) {
                acl = acl.newInheritingACL(newAcl);
            }
            sb.append(FOLDER_SEPARATOR);
        }
        this.jobAclCache.put((Object)fullName, (Object)acl);
        return acl;
    }

    @Nonnull
    public SidACL getACL(@Nonnull Computer computer) {
        String name = computer.getName();
        SidACL acl = this.agentAcls.get(name);
        if (acl == null) {
            return this.globalAcl;
        }
        return this.globalAcl.newInheritingACL(acl);
    }

    @Nonnull
    public Collection<String> getGroups() {
        ConcurrentHashMap.KeySetView groups = ConcurrentHashMap.newKeySet();
        ((Stream)this.agentRoles.stream().parallel()).map(AbstractRole::getSids).forEach(groups::addAll);
        ((Stream)this.globalRoles.stream().parallel()).map(AbstractRole::getSids).forEach(groups::addAll);
        ((Stream)this.folderRoles.stream().parallel()).map(AbstractRole::getSids).forEach(groups::addAll);
        return Collections.unmodifiableCollection(groups);
    }

    @Nonnull
    public Set<GlobalRole> getGlobalRoles() {
        return Collections.unmodifiableSet(this.globalRoles);
    }

    @Nonnull
    public Set<AgentRole> getAgentRoles() {
        return Collections.unmodifiableSet(this.agentRoles);
    }

    @Nonnull
    public Set<FolderRole> getFolderRoles() {
        return Collections.unmodifiableSet(this.folderRoles);
    }

    private void updateAclForFolderRole(FolderRole role) {
        for (String name : role.getFolderNames()) {
            this.updateGenericAcl(name, this.jobAcls, role);
        }
    }

    private void updateAclForAgentRole(AgentRole role) {
        for (String agent : role.getAgents()) {
            this.updateGenericAcl(agent, this.agentAcls, role);
        }
    }

    private void updateGenericAcl(String fullName, ConcurrentHashMap<String, GenericAclImpl> acls, AbstractRole role) {
        GenericAclImpl acl = acls.get(fullName);
        if (acl == null) {
            acl = new GenericAclImpl();
        }
        acl.assignPermissions(role.getSids(), role.getPermissionsUnsorted().stream().map(PermissionWrapper::getPermission).collect(Collectors.toSet()));
        acls.put(fullName, acl);
    }

    private void init() {
        this.jobAcls = new ConcurrentHashMap();
        this.agentAcls = new ConcurrentHashMap();
        this.jobAclCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(2048L).build();
        this.globalAcl = new GlobalAclImpl(this.globalRoles);
        this.updateJobAcls();
        this.updateAgentAcls();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        @Nonnull
        public String getDisplayName() {
            return Messages.FolderBasedAuthorizationStrategy_DisplayName();
        }

        @Nonnull
        public FolderBasedAuthorizationStrategy newInstance(@Nullable StaplerRequest req, @Nonnull JSONObject formData) {
            AuthorizationStrategy strategy = Jenkins.get().getAuthorizationStrategy();
            if (strategy instanceof FolderBasedAuthorizationStrategy) {
                return (FolderBasedAuthorizationStrategy)strategy;
            }
            HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>(PermissionGroup.getAll());
            groups.remove(PermissionGroup.get(Permission.class));
            Set<PermissionWrapper> adminPermissions = PermissionWrapper.wrapPermissions(FolderAuthorizationStrategyManagementLink.getSafePermissions(groups));
            GlobalRole adminRole = new GlobalRole(FolderBasedAuthorizationStrategy.ADMIN_ROLE_NAME, adminPermissions, Collections.singleton(new PrincipalSid(Jenkins.getAuthentication()).getPrincipal()));
            return new FolderBasedAuthorizationStrategy(Collections.singleton(adminRole), Collections.emptySet(), Collections.emptySet());
        }
    }
}

