/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth.roles;

import io.jenkins.plugins.folderauth.misc.PermissionWrapper;
import io.jenkins.plugins.folderauth.roles.AbstractRole;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.kohsuke.stapler.DataBoundConstructor;

@ParametersAreNonnullByDefault
public class AgentRole
extends AbstractRole {
    private final Set<String> agents;

    @DataBoundConstructor
    public AgentRole(String name, Set<PermissionWrapper> permissions, Set<String> agents, Set<String> sids) {
        super(name, permissions, sids);
        this.agents = new HashSet<String>(agents);
    }

    public AgentRole(String name, Set<PermissionWrapper> permissions, Set<String> agents) {
        this(name, permissions, agents, Collections.emptySet());
    }

    @Nonnull
    public Set<String> getAgents() {
        return Collections.unmodifiableSet(this.agents);
    }

    @Nonnull
    public String getAgentNamesCommaSeparated() {
        String csv = this.agents.toString();
        return csv.substring(1, csv.length() - 1);
    }
}

