/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth.roles;

import io.jenkins.plugins.folderauth.misc.PermissionWrapper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class AbstractRole {
    @Nonnull
    protected final String name;
    @Nonnull
    private final Set<PermissionWrapper> permissionWrappers;
    @Nonnull
    protected final Set<String> sids;

    AbstractRole(String name, Set<PermissionWrapper> permissions, Set<String> sids) {
        this.name = name;
        this.permissionWrappers = new HashSet<PermissionWrapper>(permissions);
        this.sids = new HashSet<String>(sids);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRole role = (AbstractRole)o;
        return this.name.equals(role.name) && this.permissionWrappers.equals(role.permissionWrappers) && this.sids.equals(role.sids);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.permissionWrappers, this.sids);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<PermissionWrapper> getPermissions() {
        return Collections.unmodifiableSet(this.permissionWrappers);
    }

    @Nonnull
    public Set<String> getSids() {
        return Collections.unmodifiableSet(this.sids);
    }

    @Nonnull
    public String getSidsCommaSeparated() {
        String string = this.sids.toString();
        return string.substring(1, string.length() - 1);
    }
}

