/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth.misc;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class PermissionFinder {
    private static final Pattern PERMISSION_PATTERN = Pattern.compile("^([^\\/]+)\\/(.+)$");

    @CheckForNull
    public static Permission findPermission(String id) {
        if (id.contains("/")) {
            String resolvedId = PermissionFinder.findPermissionId(id);
            return resolvedId != null ? Permission.fromId((String)resolvedId) : null;
        }
        return Permission.fromId((String)id);
    }

    @CheckForNull
    public static String findPermissionId(String id) {
        List pgs = PermissionGroup.getAll();
        Matcher m = PERMISSION_PATTERN.matcher(id);
        if (m.matches()) {
            String owner = m.group(1);
            String name = m.group(2);
            for (PermissionGroup pg : pgs) {
                if (pg.owner.equals(Permission.class) || !pg.getId().equals(owner)) continue;
                return pg.owner.getName() + "." + name;
            }
        }
        return null;
    }
}

