/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth.acls;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.security.Permission;
import hudson.security.SidACL;
import io.jenkins.plugins.folderauth.misc.PermissionWrapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.acegisecurity.acls.sid.Sid;
import org.apache.commons.collections.CollectionUtils;

abstract class AbstractAcl
extends SidACL {
    private static ConcurrentHashMap<Permission, Set<Permission>> implyingPermissionsCache = new ConcurrentHashMap();
    protected Map<String, Set<Permission>> permissionList = new ConcurrentHashMap<String, Set<Permission>>();

    AbstractAcl() {
    }

    private static Set<Permission> cacheImplyingPermissions(Permission permission) {
        Set<Permission> implyingPermissions;
        if (PermissionWrapper.DANGEROUS_PERMISSIONS.contains(permission)) {
            implyingPermissions = AbstractAcl.getImplyingPermissions(Jenkins.ADMINISTER);
        } else {
            implyingPermissions = new HashSet<Permission>();
            Permission p = permission;
            while (p != null) {
                implyingPermissions.add(p);
                p = p.impliedBy;
            }
        }
        implyingPermissionsCache.put(permission, implyingPermissions);
        return implyingPermissions;
    }

    private static Set<Permission> getImplyingPermissions(Permission p) {
        Set<Permission> permissions = implyingPermissionsCache.get(p);
        if (permissions != null) {
            return permissions;
        }
        return AbstractAcl.cacheImplyingPermissions(p);
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="hudson.security.SidACL requires null when unknown")
    protected Boolean hasPermission(Sid sid, Permission permission) {
        Set<Permission> permissions;
        if (PermissionWrapper.DANGEROUS_PERMISSIONS.contains(permission)) {
            permission = Jenkins.ADMINISTER;
        }
        if ((permissions = this.permissionList.get(this.toString(sid))) != null && CollectionUtils.containsAny(permissions, AbstractAcl.getImplyingPermissions(permission))) {
            return true;
        }
        return null;
    }

    static {
        Permission.getAll().forEach(AbstractAcl::cacheImplyingPermissions);
    }
}

