/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Api;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ManagementLink;
import hudson.model.Run;
import hudson.model.View;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import io.jenkins.plugins.folderauth.FolderAuthorizationStrategyAPI;
import io.jenkins.plugins.folderauth.FolderBasedAuthorizationStrategy;
import io.jenkins.plugins.folderauth.Messages;
import io.jenkins.plugins.folderauth.misc.AgentRoleCreationRequest;
import io.jenkins.plugins.folderauth.misc.FolderRoleCreationRequest;
import io.jenkins.plugins.folderauth.misc.GlobalRoleCreationRequest;
import io.jenkins.plugins.folderauth.misc.PermissionWrapper;
import io.jenkins.plugins.folderauth.roles.AgentRole;
import io.jenkins.plugins.folderauth.roles.FolderRole;
import io.jenkins.plugins.folderauth.roles.GlobalRole;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.verb.GET;

@Extension
@ExportedBean
@ParametersAreNonnullByDefault
public class FolderAuthorizationStrategyManagementLink
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger(FolderAuthorizationStrategyManagementLink.class.getName());

    @CheckForNull
    public String getIconFileName() {
        return Jenkins.get().getAuthorizationStrategy() instanceof FolderBasedAuthorizationStrategy ? "lock.png" : null;
    }

    @Nonnull
    public String getDescription() {
        return Messages.FolderBasedAuthorizationStrategy_Description();
    }

    @CheckForNull
    public String getUrlName() {
        return "folder-auth";
    }

    @CheckForNull
    public String getDisplayName() {
        return Messages.FolderBasedAuthorizationStrategy_DisplayName();
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Set<Permission> getGlobalPermissions() {
        HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>(PermissionGroup.getAll());
        groups.remove(PermissionGroup.get(Permission.class));
        return FolderAuthorizationStrategyManagementLink.getSafePermissions(groups);
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Set<Permission> getFolderPermissions() {
        HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>(PermissionGroup.getAll());
        groups.remove(PermissionGroup.get(Hudson.class));
        groups.remove(PermissionGroup.get(Computer.class));
        groups.remove(PermissionGroup.get(Permission.class));
        return FolderAuthorizationStrategyManagementLink.getSafePermissions(groups);
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Set<Permission> getAgentPermissions() {
        HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>(PermissionGroup.getAll());
        groups.remove(PermissionGroup.get(Run.class));
        groups.remove(PermissionGroup.get(SCM.class));
        groups.remove(PermissionGroup.get(View.class));
        groups.remove(PermissionGroup.get(Item.class));
        groups.remove(PermissionGroup.get(Hudson.class));
        groups.remove(PermissionGroup.get(Permission.class));
        return FolderAuthorizationStrategyManagementLink.getSafePermissions(groups);
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAddGlobalRole(@JsonBody GlobalRoleCreationRequest request) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FolderAuthorizationStrategyAPI.addGlobalRole(request.getGlobalRole());
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignSidToGlobalRole(@QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FolderAuthorizationStrategyAPI.assignSidToGlobalRole(sid, roleName);
        this.redirect();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAddFolderRole(@JsonBody FolderRoleCreationRequest request) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FolderAuthorizationStrategyAPI.addFolderRole(request.getFolderRole());
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAddAgentRole(@JsonBody AgentRoleCreationRequest request) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FolderAuthorizationStrategyAPI.addAgentRole(request.getAgentRole());
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignSidToFolderRole(@QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FolderAuthorizationStrategyAPI.assignSidToFolderRole(sid, roleName);
        this.redirect();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignSidToAgentRole(@QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FolderAuthorizationStrategyAPI.assignSidToAgentRole(sid, roleName);
        this.redirect();
    }

    private void redirect() {
        try {
            Stapler.getCurrentResponse().forwardToPreviousPage(Stapler.getCurrentRequest());
        }
        catch (IOException | ServletException e) {
            LOGGER.log(Level.WARNING, "Unable to redirect to previous page.");
        }
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Set<GlobalRole> getGlobalRoles() {
        AuthorizationStrategy strategy = Jenkins.get().getAuthorizationStrategy();
        if (strategy instanceof FolderBasedAuthorizationStrategy) {
            return ((FolderBasedAuthorizationStrategy)strategy).getGlobalRoles();
        }
        throw new IllegalStateException(Messages.FolderBasedAuthorizationStrategy_NotCurrentStrategy());
    }

    @GET
    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public JSONArray doGetAllFolders() {
        List folders;
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
            folders = jenkins.getAllItems(AbstractFolder.class);
        }
        return JSONArray.fromObject(folders.stream().map(AbstractItem::getFullName).collect(Collectors.toList()));
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public List<Computer> getAllComputers() {
        Computer[] computers;
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
            computers = jenkins.getComputers();
        }
        return Arrays.asList(computers);
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Set<FolderRole> getFolderRoles() {
        AuthorizationStrategy strategy = Jenkins.get().getAuthorizationStrategy();
        if (strategy instanceof FolderBasedAuthorizationStrategy) {
            return ((FolderBasedAuthorizationStrategy)strategy).getFolderRoles();
        }
        throw new IllegalStateException(Messages.FolderBasedAuthorizationStrategy_NotCurrentStrategy());
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public Set<AgentRole> getAgentRoles() {
        AuthorizationStrategy strategy = Jenkins.get().getAuthorizationStrategy();
        if (strategy instanceof FolderBasedAuthorizationStrategy) {
            return ((FolderBasedAuthorizationStrategy)strategy).getAgentRoles();
        }
        throw new IllegalStateException(Messages.FolderBasedAuthorizationStrategy_NotCurrentStrategy());
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteGlobalRole(@QueryParameter(required=true) String roleName) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FolderAuthorizationStrategyAPI.deleteGlobalRole(roleName);
        this.redirect();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteFolderRole(@QueryParameter(required=true) String roleName) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FolderAuthorizationStrategyAPI.deleteFolderRole(roleName);
        this.redirect();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteAgentRole(@QueryParameter(required=true) String roleName) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FolderAuthorizationStrategyAPI.deleteAgentRole(roleName);
        this.redirect();
    }

    @Nonnull
    static Set<Permission> getSafePermissions(Set<PermissionGroup> groups) {
        HashSet<Permission> safePermissions = new HashSet<Permission>();
        groups.stream().map(PermissionGroup::getPermissions).forEach(safePermissions::addAll);
        safePermissions.removeAll(PermissionWrapper.DANGEROUS_PERMISSIONS);
        return safePermissions;
    }
}

