/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth;

import hudson.security.AuthorizationStrategy;
import io.jenkins.plugins.folderauth.FolderBasedAuthorizationStrategy;
import io.jenkins.plugins.folderauth.roles.AgentRole;
import io.jenkins.plugins.folderauth.roles.FolderRole;
import io.jenkins.plugins.folderauth.roles.GlobalRole;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

@ParametersAreNonnullByDefault
public class FolderAuthorizationStrategyAPI {
    private FolderAuthorizationStrategyAPI() {
    }

    private static synchronized void run(Function<FolderBasedAuthorizationStrategy, FolderBasedAuthorizationStrategy> runner) {
        Jenkins jenkins = Jenkins.get();
        AuthorizationStrategy strategy = jenkins.getAuthorizationStrategy();
        if (!(strategy instanceof FolderBasedAuthorizationStrategy)) {
            throw new IllegalStateException("FolderBasedAuthorizationStrategy is not the current authorization strategy");
        }
        FolderBasedAuthorizationStrategy newStrategy = runner.apply((FolderBasedAuthorizationStrategy)strategy);
        jenkins.setAuthorizationStrategy((AuthorizationStrategy)newStrategy);
    }

    public static void addGlobalRole(GlobalRole role) {
        FolderAuthorizationStrategyAPI.run(strategy -> {
            HashSet<GlobalRole> globalRoles = new HashSet<GlobalRole>(strategy.getGlobalRoles());
            String name = role.getName();
            Optional<GlobalRole> existing = globalRoles.stream().filter(r -> r.getName().equals(name)).findAny();
            if (existing.isPresent()) {
                throw new IllegalArgumentException("A global role with the name \"" + name + "\" already exists.");
            }
            globalRoles.add(role);
            return new FolderBasedAuthorizationStrategy(globalRoles, strategy.getFolderRoles(), strategy.getAgentRoles());
        });
    }

    public static void addFolderRole(FolderRole role) {
        FolderAuthorizationStrategyAPI.run(strategy -> {
            HashSet<FolderRole> folderRoles = new HashSet<FolderRole>(strategy.getFolderRoles());
            String name = role.getName();
            Optional<FolderRole> existing = folderRoles.stream().filter(r -> r.getName().equals(name)).findAny();
            if (existing.isPresent()) {
                throw new IllegalArgumentException("A folder role with the name \"" + name + "\" already exists.");
            }
            folderRoles.add(role);
            return new FolderBasedAuthorizationStrategy(strategy.getGlobalRoles(), folderRoles, strategy.getAgentRoles());
        });
    }

    public static void addAgentRole(AgentRole role) {
        FolderAuthorizationStrategyAPI.run(strategy -> {
            HashSet<AgentRole> agentRoles = new HashSet<AgentRole>(strategy.getAgentRoles());
            String name = role.getName();
            Optional<AgentRole> existing = agentRoles.stream().filter(r -> r.getName().equals(name)).findAny();
            if (existing.isPresent()) {
                throw new IllegalArgumentException("An agent role with the name \"" + name + "\" already exists.");
            }
            agentRoles.add(role);
            return new FolderBasedAuthorizationStrategy(strategy.getGlobalRoles(), strategy.getFolderRoles(), agentRoles);
        });
    }

    public static void assignSidToGlobalRole(String sid, String roleName) {
        if (StringUtils.isBlank((String)sid)) {
            throw new IllegalArgumentException("Sid should not be blank.");
        }
        FolderAuthorizationStrategyAPI.run(strategy -> {
            HashSet<GlobalRole> globalRoles = new HashSet<GlobalRole>(strategy.getGlobalRoles());
            GlobalRole role = globalRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new IllegalArgumentException("No global role with name = \"" + roleName + "\" exists"));
            HashSet<String> newSids = new HashSet<String>(role.getSids());
            newSids.add(sid);
            globalRoles.remove(role);
            globalRoles.add(new GlobalRole(role.getName(), role.getPermissions(), newSids));
            return new FolderBasedAuthorizationStrategy(globalRoles, strategy.getFolderRoles(), strategy.getAgentRoles());
        });
    }

    public static void assignSidToAgentRole(String sid, String roleName) {
        if (StringUtils.isBlank((String)sid)) {
            throw new IllegalArgumentException("Sid should not be blank.");
        }
        FolderAuthorizationStrategyAPI.run(strategy -> {
            HashSet<AgentRole> agentRoles = new HashSet<AgentRole>(strategy.getAgentRoles());
            AgentRole role = agentRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new IllegalArgumentException("No agent role with name = \"" + roleName + "\" exists"));
            HashSet<String> newSids = new HashSet<String>(role.getSids());
            newSids.add(sid);
            agentRoles.remove(role);
            agentRoles.add(new AgentRole(role.getName(), role.getPermissions(), role.getAgents(), newSids));
            return new FolderBasedAuthorizationStrategy(strategy.getGlobalRoles(), strategy.getFolderRoles(), agentRoles);
        });
    }

    public static void assignSidToFolderRole(String sid, String roleName) {
        if (StringUtils.isBlank((String)sid)) {
            throw new IllegalArgumentException("Sid should not be blank.");
        }
        FolderAuthorizationStrategyAPI.run(strategy -> {
            HashSet<FolderRole> folderRoles = new HashSet<FolderRole>(strategy.getFolderRoles());
            FolderRole role = folderRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new IllegalArgumentException("No folder role with name = \"" + roleName + "\" exists"));
            HashSet<String> newSids = new HashSet<String>(role.getSids());
            newSids.add(sid);
            folderRoles.remove(role);
            folderRoles.add(new FolderRole(role.getName(), role.getPermissions(), role.getFolderNames(), newSids));
            return new FolderBasedAuthorizationStrategy(strategy.getGlobalRoles(), folderRoles, strategy.getAgentRoles());
        });
    }

    public static void deleteGlobalRole(String roleName) {
        if (roleName.equals("admin")) {
            throw new IllegalArgumentException("Cannot delete the admin role.");
        }
        FolderAuthorizationStrategyAPI.run(strategy -> {
            HashSet<GlobalRole> globalRoles = new HashSet<GlobalRole>(strategy.getGlobalRoles());
            GlobalRole role = globalRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new IllegalArgumentException("No global role with name = \"" + roleName + "\" exists"));
            globalRoles.remove(role);
            return new FolderBasedAuthorizationStrategy(globalRoles, strategy.getFolderRoles(), strategy.getAgentRoles());
        });
    }

    public static void deleteFolderRole(String roleName) {
        FolderAuthorizationStrategyAPI.run(strategy -> {
            HashSet<FolderRole> folderRoles = new HashSet<FolderRole>(strategy.getFolderRoles());
            FolderRole role = folderRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new IllegalArgumentException("No folder role with name = \"" + roleName + "\" exists"));
            folderRoles.remove(role);
            return new FolderBasedAuthorizationStrategy(strategy.getGlobalRoles(), folderRoles, strategy.getAgentRoles());
        });
    }

    public static void deleteAgentRole(String roleName) {
        FolderAuthorizationStrategyAPI.run(strategy -> {
            HashSet<AgentRole> agentRoles = new HashSet<AgentRole>(strategy.getAgentRoles());
            AgentRole role = agentRoles.stream().filter(r -> r.getName().equals(roleName)).findAny().orElseThrow(() -> new IllegalArgumentException("No agent role with name = \"" + roleName + "\" exists"));
            agentRoles.remove(role);
            return new FolderBasedAuthorizationStrategy(strategy.getGlobalRoles(), strategy.getFolderRoles(), agentRoles);
        });
    }
}

