// CHECKSTYLE:OFF

package io.jenkins.plugins.folderauth;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code FolderBasedAuthorizationStrategy.ManageGlobalRoles}: {@code

     * Manage Global Roles}.
     * 
     * @return
     *     {@code Manage Global Roles}
     */
    public static String FolderBasedAuthorizationStrategy_ManageGlobalRoles() {
        return holder.format("FolderBasedAuthorizationStrategy.ManageGlobalRoles");
    }

    /**
     * Key {@code FolderBasedAuthorizationStrategy.ManageGlobalRoles}: {@code

     * Manage Global Roles}.
     * 
     * @return
     *     {@code Manage Global Roles}
     */
    public static Localizable _FolderBasedAuthorizationStrategy_ManageGlobalRoles() {
        return new Localizable(holder, "FolderBasedAuthorizationStrategy.ManageGlobalRoles");
    }

    /**
     * Key {@code PermissionWrapper.UnknownPermission}: {@code Unable to

     * infer permission from the given Id: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to infer permission from the given Id: {0}}
     */
    public static String PermissionWrapper_UnknownPermission(Object arg0) {
        return holder.format("PermissionWrapper.UnknownPermission", arg0);
    }

    /**
     * Key {@code PermissionWrapper.UnknownPermission}: {@code Unable to

     * infer permission from the given Id: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to infer permission from the given Id: {0}}
     */
    public static Localizable _PermissionWrapper_UnknownPermission(Object arg0) {
        return new Localizable(holder, "PermissionWrapper.UnknownPermission", arg0);
    }

    /**
     * Key {@code PermissionWrapper.NoDangerousPermissions}: {@code Dangerous

     * permissions are not supported.}.
     * 
     * @return
     *     {@code Dangerous permissions are not supported.}
     */
    public static String PermissionWrapper_NoDangerousPermissions() {
        return holder.format("PermissionWrapper.NoDangerousPermissions");
    }

    /**
     * Key {@code PermissionWrapper.NoDangerousPermissions}: {@code Dangerous

     * permissions are not supported.}.
     * 
     * @return
     *     {@code Dangerous permissions are not supported.}
     */
    public static Localizable _PermissionWrapper_NoDangerousPermissions() {
        return new Localizable(holder, "PermissionWrapper.NoDangerousPermissions");
    }

    /**
     * Key {@code FolderBasedAuthorizationStrategy.DisplayName}: {@code

     * Folder Authorization Strategy}.
     * 
     * @return
     *     {@code Folder Authorization Strategy}
     */
    public static String FolderBasedAuthorizationStrategy_DisplayName() {
        return holder.format("FolderBasedAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code FolderBasedAuthorizationStrategy.DisplayName}: {@code

     * Folder Authorization Strategy}.
     * 
     * @return
     *     {@code Folder Authorization Strategy}
     */
    public static Localizable _FolderBasedAuthorizationStrategy_DisplayName() {
        return new Localizable(holder, "FolderBasedAuthorizationStrategy.DisplayName");
    }

    /**
     * Key {@code FolderBasedAuthorizationStrategy.Description}: {@code

     * Manage roles and the users assigned to them}.
     * 
     * @return
     *     {@code Manage roles and the users assigned to them}
     */
    public static String FolderBasedAuthorizationStrategy_Description() {
        return holder.format("FolderBasedAuthorizationStrategy.Description");
    }

    /**
     * Key {@code FolderBasedAuthorizationStrategy.Description}: {@code

     * Manage roles and the users assigned to them}.
     * 
     * @return
     *     {@code Manage roles and the users assigned to them}
     */
    public static Localizable _FolderBasedAuthorizationStrategy_Description() {
        return new Localizable(holder, "FolderBasedAuthorizationStrategy.Description");
    }

    /**
     * Key {@code FolderBasedAuthorizationStrategy.NotCurrentStrategy}:

     * {@code FolderBasedAuthorizationStrategy is not the

     * AuthorizationStrategy}.
     * 
     * @return
     *     {@code FolderBasedAuthorizationStrategy is not the

     *     AuthorizationStrategy}
     */
    public static String FolderBasedAuthorizationStrategy_NotCurrentStrategy() {
        return holder.format("FolderBasedAuthorizationStrategy.NotCurrentStrategy");
    }

    /**
     * Key {@code FolderBasedAuthorizationStrategy.NotCurrentStrategy}:

     * {@code FolderBasedAuthorizationStrategy is not the

     * AuthorizationStrategy}.
     * 
     * @return
     *     {@code FolderBasedAuthorizationStrategy is not the

     *     AuthorizationStrategy}
     */
    public static Localizable _FolderBasedAuthorizationStrategy_NotCurrentStrategy() {
        return new Localizable(holder, "FolderBasedAuthorizationStrategy.NotCurrentStrategy");
    }

}
