/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth.roles;

import io.jenkins.plugins.folderauth.misc.PermissionWrapper;
import io.jenkins.plugins.folderauth.roles.AbstractRole;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.kohsuke.stapler.DataBoundConstructor;

public class FolderRole
extends AbstractRole
implements Comparable<FolderRole> {
    @Nonnull
    private final Set<String> folders;

    @DataBoundConstructor
    @ParametersAreNonnullByDefault
    public FolderRole(String name, Set<PermissionWrapper> permissions, Set<String> folders, Set<String> sids) {
        super(name, permissions);
        this.sids.addAll(sids);
        this.folders = ConcurrentHashMap.newKeySet();
        this.folders.addAll(folders);
    }

    public FolderRole(String name, Set<PermissionWrapper> permissions, Set<String> folders) {
        this(name, permissions, folders, Collections.emptySet());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.sids, this.permissionWrappers);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FolderRole that = (FolderRole)o;
        return this.name.equals(that.name) && this.sids.equals(that.sids) && this.permissionWrappers.equals(that.permissionWrappers);
    }

    @Override
    public int compareTo(@Nonnull FolderRole other) {
        return this.name.compareTo(other.name);
    }

    @Nonnull
    public Set<String> getFolderNames() {
        return Collections.unmodifiableSet(this.folders);
    }

    public String getFolderNamesCommaSeparated() {
        String csv = this.folders.toString();
        return csv.substring(1, csv.length() - 1);
    }
}

