/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth.roles;

import io.jenkins.plugins.folderauth.misc.PermissionWrapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class AbstractRole {
    @Nonnull
    protected final String name;
    @Nonnull
    protected final Set<PermissionWrapper> permissionWrappers;
    @Nonnull
    protected final Set<String> sids;

    @ParametersAreNonnullByDefault
    public AbstractRole(String name, Set<PermissionWrapper> permissionWrappers) {
        this.name = name;
        this.sids = ConcurrentHashMap.newKeySet();
        this.permissionWrappers = Collections.unmodifiableSet(permissionWrappers);
    }

    public void assignSids(String ... sids) {
        this.assignSids(Arrays.asList(sids));
    }

    public void assignSids(@Nonnull List<String> sids) {
        this.sids.addAll(sids);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractRole role = (AbstractRole)o;
        return this.name.equals(role.name) && this.permissionWrappers.equals(role.permissionWrappers) && this.sids.equals(role.sids);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.permissionWrappers, this.sids);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<PermissionWrapper> getPermissions() {
        return Collections.unmodifiableSet(this.permissionWrappers);
    }

    @Nonnull
    public Set<String> getSids() {
        return this.sids;
    }

    @Nonnull
    public String getSidsCommaSeparated() {
        String string = this.sids.toString();
        return string.substring(1, string.length() - 1);
    }

    public void unassignSids(String ... sids) {
        this.sids.removeAll(Arrays.asList(sids));
    }

    public void unassignSids(@Nonnull List<String> sids) {
        this.sids.removeAll(sids);
    }
}

