/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.folderauth.misc;

import hudson.PluginManager;
import hudson.security.Permission;
import io.jenkins.plugins.folderauth.Messages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public final class PermissionWrapper {
    private transient Permission permission;
    private final String id;
    @Restricted(value={NoExternalUse.class})
    public static final Set<Permission> DANGEROUS_PERMISSIONS = Collections.unmodifiableSet(new HashSet<Permission>(Arrays.asList(Jenkins.RUN_SCRIPTS, PluginManager.CONFIGURE_UPDATECENTER, PluginManager.UPLOAD_PLUGINS)));

    @DataBoundConstructor
    public PermissionWrapper(@Nonnull String id) {
        this.id = id;
        this.permission = Permission.fromId((String)id);
        this.checkPermission();
    }

    @Nonnull
    private Object readResolve() {
        this.permission = Permission.fromId((String)this.id);
        this.checkPermission();
        return this;
    }

    @Nonnull
    public Permission getPermission() {
        return this.permission;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionWrapper that = (PermissionWrapper)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private void checkPermission() {
        if (this.permission == null) {
            throw new IllegalArgumentException(Messages.PermissionWrapper_UnknownPermission() + " " + this.id);
        }
        if (DANGEROUS_PERMISSIONS.contains(this.permission)) {
            throw new IllegalArgumentException(Messages.PermissionWrapper_NoDangerousPermissions());
        }
    }

    @Nonnull
    public static Set<PermissionWrapper> wrapPermissions(Permission ... permissions) {
        return PermissionWrapper._wrapPermissions(Arrays.stream(permissions));
    }

    @Nonnull
    public static Set<PermissionWrapper> wrapPermissions(Collection<Permission> permissions) {
        return PermissionWrapper._wrapPermissions(permissions.stream());
    }

    @Nonnull
    private static Set<PermissionWrapper> _wrapPermissions(Stream<Permission> stream) {
        return stream.map(Permission::getId).map(PermissionWrapper::new).collect(Collectors.toSet());
    }
}

